/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.authorizationcode;

import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.module.http.api.listener.HttpListenerConfig;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.runtime.module.oauth2.api.RequestAuthenticationException;
import org.mule.runtime.module.oauth2.internal.AbstractGrantType;
import org.mule.runtime.module.oauth2.internal.authorizationcode.AbstractAuthorizationCodeTokenRequestHandler;
import org.mule.runtime.module.oauth2.internal.authorizationcode.AuthorizationCodeGrantType;
import org.mule.runtime.module.oauth2.internal.authorizationcode.AuthorizationRequestHandler;
import org.mule.runtime.module.oauth2.internal.authorizationcode.state.ConfigOAuthContext;
import org.mule.runtime.module.oauth2.internal.tokenmanager.TokenManagerConfig;

public class DefaultAuthorizationCodeGrantType
extends AbstractGrantType
implements Initialisable,
AuthorizationCodeGrantType,
Startable,
MuleContextAware {
    private String clientId;
    private String clientSecret;
    private HttpListenerConfig localCallbackConfig;
    private String localCallbackConfigPath;
    private String localCallbackUrl;
    private String externalCallbackUrl;
    private AuthorizationRequestHandler authorizationRequestHandler;
    private AbstractAuthorizationCodeTokenRequestHandler tokenRequestHandler;
    private MuleContext muleContext;
    private TlsContextFactory tlsContextFactory;
    private TokenManagerConfig tokenManagerConfig;
    private AttributeEvaluator localAuthorizationUrlResourceOwnerIdEvaluator;
    private AttributeEvaluator resourceOwnerIdEvaluator;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setAuthorizationRequestHandler(AuthorizationRequestHandler authorizationRequestHandler) {
        this.authorizationRequestHandler = authorizationRequestHandler;
    }

    public void setTokenRequestHandler(AbstractAuthorizationCodeTokenRequestHandler tokenRequestHandler) {
        this.tokenRequestHandler = tokenRequestHandler;
    }

    public void setLocalCallbackConfig(HttpListenerConfig localCallbackConfig) {
        this.localCallbackConfig = localCallbackConfig;
    }

    public void setLocalCallbackConfigPath(String localCallbackConfigPath) {
        this.localCallbackConfigPath = localCallbackConfigPath;
    }

    public void setLocalCallbackUrl(String localCallbackUrl) {
        this.localCallbackUrl = localCallbackUrl;
    }

    public void setExternalCallbackUrl(String externalCallbackUrl) {
        this.externalCallbackUrl = externalCallbackUrl;
    }

    @Override
    public HttpListenerConfig getLocalCallbackConfig() {
        return this.localCallbackConfig;
    }

    @Override
    public String getLocalCallbackConfigPath() {
        return this.localCallbackConfigPath;
    }

    @Override
    public String getLocalCallbackUrl() {
        return this.localCallbackUrl;
    }

    @Override
    public String getExternalCallbackUrl() {
        return this.externalCallbackUrl;
    }

    public ConfigOAuthContext getConfigOAuthContext() {
        return this.tokenManagerConfig.getConfigOAuthContext();
    }

    @Override
    public String getRefreshTokenWhen() {
        return this.tokenRequestHandler.getRefreshTokenWhen();
    }

    @Override
    public AttributeEvaluator getLocalAuthorizationUrlResourceOwnerIdEvaluator() {
        return this.localAuthorizationUrlResourceOwnerIdEvaluator;
    }

    @Override
    public AttributeEvaluator getResourceOwnerIdEvaluator() {
        return this.resourceOwnerIdEvaluator;
    }

    @Override
    public void refreshToken(Event currentFlowEvent, String resourceOwnerId) throws MuleException {
        this.tokenRequestHandler.refreshToken(currentFlowEvent, resourceOwnerId);
    }

    @Override
    public ConfigOAuthContext getUserOAuthContext() {
        return this.tokenManagerConfig.getConfigOAuthContext();
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }

    public void initialise() throws InitialisationException {
        try {
            if (this.tokenManagerConfig == null) {
                this.tokenManagerConfig = TokenManagerConfig.createDefault(this.muleContext);
                this.tokenManagerConfig.initialise();
            }
            if (this.localAuthorizationUrlResourceOwnerIdEvaluator == null) {
                this.localAuthorizationUrlResourceOwnerIdEvaluator = new AttributeEvaluator(null);
            }
            this.localAuthorizationUrlResourceOwnerIdEvaluator.initialize(this.muleContext.getExpressionManager());
            if (this.resourceOwnerIdEvaluator == null) {
                this.resourceOwnerIdEvaluator = new AttributeEvaluator("default");
            }
            this.resourceOwnerIdEvaluator.initialize(this.muleContext.getExpressionManager());
            if (this.localCallbackConfig != null && this.localCallbackUrl != null) {
                throw new IllegalArgumentException("Attributes localCallbackConfig and localCallbackUrl are mutually exclusive");
            }
            if (this.localCallbackConfig == null != (this.localCallbackConfigPath == null)) {
                throw new IllegalArgumentException("Attributes localCallbackConfig and localCallbackConfigPath must be both present or absent");
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void authenticate(Event muleEvent, HttpRequestBuilder builder) throws MuleException {
        String resourceOwnerId = this.resourceOwnerIdEvaluator.resolveStringValue(muleEvent);
        if (resourceOwnerId == null) {
            throw new RequestAuthenticationException(I18nMessageFactory.createStaticMessage((String)String.format("Evaluation of %s return an empty resourceOwnerId", this.localAuthorizationUrlResourceOwnerIdEvaluator.getRawValue())));
        }
        String accessToken = this.getUserOAuthContext().getContextForResourceOwner(resourceOwnerId).getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(I18nMessageFactory.createStaticMessage((String)String.format("No access token for the %s user. Verify that you have authenticated the user before trying to execute an operation to the API.", resourceOwnerId)));
        }
        builder.addHeader("Authorization", DefaultAuthorizationCodeGrantType.buildAuthorizationHeaderContent(accessToken));
    }

    public boolean shouldRetry(Event firstAttemptResponseEvent) throws MuleException {
        if (!StringUtils.isBlank((String)this.getRefreshTokenWhen())) {
            Object value = this.muleContext.getExpressionManager().evaluate(this.getRefreshTokenWhen(), firstAttemptResponseEvent).getValue();
            if (!(value instanceof Boolean)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expression %s should return a boolean but return %s", (Object[])new Object[]{this.getRefreshTokenWhen(), value}));
            }
            Boolean shouldRetryRequest = (Boolean)value;
            if (shouldRetryRequest.booleanValue()) {
                try {
                    this.refreshToken(firstAttemptResponseEvent, this.resourceOwnerIdEvaluator.resolveStringValue(firstAttemptResponseEvent));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            return shouldRetryRequest;
        }
        return false;
    }

    public void setLocalAuthorizationUrlResourceOwnerId(String resourceOwnerId) {
        this.localAuthorizationUrlResourceOwnerIdEvaluator = new AttributeEvaluator(resourceOwnerId);
    }

    public void setResourceOwnerId(String resourceOwnerId) {
        this.resourceOwnerIdEvaluator = new AttributeEvaluator(resourceOwnerId);
    }

    public void setTokenManager(TokenManagerConfig tokenManagerConfig) {
        this.tokenManagerConfig = tokenManagerConfig;
    }

    public void start() throws MuleException {
        if (this.authorizationRequestHandler != null) {
            this.authorizationRequestHandler.setOauthConfig(this);
            this.authorizationRequestHandler.init();
        }
        if (this.tokenRequestHandler != null) {
            this.tokenRequestHandler.setOauthConfig(this);
            this.tokenRequestHandler.init();
        }
    }
}

