/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.authorizationcode;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.oauth2.internal.AbstractTokenRequestHandler;
import org.mule.runtime.module.oauth2.internal.MuleEventLogger;
import org.mule.runtime.module.oauth2.internal.StateDecoder;
import org.mule.runtime.module.oauth2.internal.TokenNotFoundException;
import org.mule.runtime.module.oauth2.internal.TokenResponseProcessor;
import org.mule.runtime.module.oauth2.internal.authorizationcode.AbstractAuthorizationCodeTokenRequestHandler;
import org.mule.runtime.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;
import org.mule.runtime.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.springframework.util.StringUtils;

public class AutoAuthorizationCodeTokenRequestHandler
extends AbstractAuthorizationCodeTokenRequestHandler {
    public static final String AUTHORIZATION_STATUS_QUERY_PARAM_KEY = "authorizationStatus";
    public static final int NO_AUTHORIZATION_CODE_STATUS = 100;
    public static final int TOKEN_URL_CALL_FAILED_STATUS = 200;
    public static final int TOKEN_NOT_FOUND_STATUS = 201;
    public static final int FAILURE_PROCESSING_REDIRECT_URL_REQUEST_STATUS = 300;
    private TokenResponseConfiguration tokenResponseConfiguration = new TokenResponseConfiguration();
    private MuleEventLogger muleEventLogger;

    public void setTokenResponseConfiguration(TokenResponseConfiguration tokenResponseConfiguration) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
    }

    @Override
    public void init() throws MuleException {
        this.createListenerForCallbackUrl();
        this.muleEventLogger = new MuleEventLogger(this.logger, this.muleContext);
    }

    @Override
    protected Processor createRedirectUrlProcessor() {
        return event -> {
            int authorizationStatus = 0;
            int statusCodeToReturn = HttpConstants.HttpStatus.OK.getStatusCode();
            String responseMessage = "Successfully retrieved access token";
            Map queryParams = (Map)((Object)event.getMessage().getInboundProperty("http.query.params"));
            String state = (String)queryParams.get("state");
            StateDecoder stateDecoder = new StateDecoder(state);
            try {
                String authorizationCode = this.processAuthorizationCode(event);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Redirect url request state: " + state);
                    this.logger.debug("Redirect url request code: " + authorizationCode);
                }
                Event tokenUrlResponse = this.callTokenUrl(event, authorizationCode);
                String decodedState = stateDecoder.decodeOriginalState();
                String encodedResourceOwnerId = stateDecoder.decodeResourceOwnerId();
                String resourceOwnerId = encodedResourceOwnerId == null ? "default" : encodedResourceOwnerId;
                ResourceOwnerOAuthContext resourceOwnerOAuthContext = this.getOauthConfig().getUserOAuthContext().getContextForResourceOwner(resourceOwnerId);
                this.logResourceOwnerOAuthContextBeforeUpdate(resourceOwnerOAuthContext);
                TokenResponseProcessor tokenResponseProcessor = this.processTokenUrlResponse(tokenUrlResponse);
                this.updateResourceOwnerState(resourceOwnerOAuthContext, decodedState, tokenResponseProcessor);
                this.getOauthConfig().getUserOAuthContext().updateResourceOwnerOAuthContext(resourceOwnerOAuthContext);
            }
            catch (NoAuthorizationCodeException e1) {
                this.logger.error("Could not extract authorization code from OAuth provider HTTP request done to the redirect URL");
                this.muleEventLogger.logContent(event);
                authorizationStatus = 100;
                statusCodeToReturn = HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode();
                responseMessage = "Failure retrieving access token.\n OAuth Server uri from callback: " + event.getMessage().getInboundProperty("http.request.uri");
            }
            catch (AbstractTokenRequestHandler.TokenUrlResponseException e2) {
                this.logger.error(String.format("HTTP response from token URL %s returned a failure status code", this.getTokenUrl()));
                this.muleEventLogger.logContent(e2.getTokenUrlResponse());
                authorizationStatus = 200;
                statusCodeToReturn = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
                responseMessage = String.format("Failure calling token url %s. Exception message is %s", this.getTokenUrl(), e2.getMessage());
            }
            catch (TokenNotFoundException e3) {
                this.logger.error(String.format("Could not extract access token from token URL. Access token is %s, Refresh token is %s", e3.getTokenResponseProcessor().getAccessToken(), org.mule.runtime.core.util.StringUtils.isBlank((String)e3.getTokenResponseProcessor().getRefreshToken()) ? "(Not issued)" : e3.getTokenResponseProcessor().getRefreshToken()));
                this.muleEventLogger.logContent(e3.getTokenUrlResponse());
                authorizationStatus = 201;
                statusCodeToReturn = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
                responseMessage = "Failed getting access token or refresh token from token URL response. See logs for details.";
            }
            catch (MuleException e4) {
                this.logger.error("Fail processing redirect URL request", (Throwable)e4);
                authorizationStatus = 300;
                statusCodeToReturn = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
                responseMessage = "Failed processing redirect URL request done from OAuth provider. See logs for details.";
            }
            String finalResponseMessage = responseMessage;
            int finalStatusCodeToReturn = statusCodeToReturn;
            int finalAuthorizationStatus = authorizationStatus;
            InternalMessage.Builder builder = InternalMessage.builder((InternalMessage)event.getMessage()).payload((Object)finalResponseMessage).addOutboundProperty("http.status", (Serializable)Integer.valueOf(finalStatusCodeToReturn));
            String onCompleteRedirectToValue = stateDecoder.decodeOnCompleteRedirectTo();
            if (!StringUtils.isEmpty((Object)onCompleteRedirectToValue)) {
                builder.addOutboundProperty("http.status", (Serializable)Integer.valueOf(HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode()));
                builder.addOutboundProperty("Location", (Serializable)((Object)HttpParser.appendQueryParam((String)onCompleteRedirectToValue, (String)AUTHORIZATION_STATUS_QUERY_PARAM_KEY, (String)String.valueOf(finalAuthorizationStatus))));
            }
            return Event.builder((Event)event).message(builder.build()).build();
        };
    }

    private Event callTokenUrl(Event event, String authorizationCode) throws MuleException, AbstractTokenRequestHandler.TokenUrlResponseException {
        event = this.setMapPayloadWithTokenRequestParameters(event, authorizationCode);
        return this.invokeTokenUrl(event);
    }

    private String processAuthorizationCode(Event event) throws NoAuthorizationCodeException {
        Map queryParams = (Map)((Object)event.getMessage().getInboundProperty("http.query.params"));
        String authorizationCode = (String)queryParams.get("code");
        if (authorizationCode == null) {
            this.logger.info("HTTP Request to redirect URL done by the OAuth provider does not contains a code query parameter. Code query parameter is required to get the access token.");
            throw new NoAuthorizationCodeException();
        }
        return authorizationCode;
    }

    private boolean tokenResponseContentIsValid(TokenResponseProcessor tokenResponseProcessor) {
        return tokenResponseProcessor.getAccessToken() != null;
    }

    private Event setMapPayloadWithTokenRequestParameters(Event event, String authorizationCode) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("code", authorizationCode);
        formData.put("client_id", this.getOauthConfig().getClientId());
        formData.put("client_secret", this.getOauthConfig().getClientSecret());
        formData.put("grant_type", "authorization_code");
        formData.put("redirect_uri", this.getOauthConfig().getExternalCallbackUrl());
        return Event.builder((Event)event).message(InternalMessage.builder((InternalMessage)event.getMessage()).payload(formData).build()).build();
    }

    private Event setMapPayloadWithRefreshTokenRequestParameters(Event event, String refreshToken) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("refresh_token", refreshToken);
        formData.put("client_id", this.getOauthConfig().getClientId());
        formData.put("client_secret", this.getOauthConfig().getClientSecret());
        formData.put("grant_type", "refresh_token");
        formData.put("redirect_uri", this.getOauthConfig().getExternalCallbackUrl());
        return Event.builder((Event)event).message(InternalMessage.builder((InternalMessage)event.getMessage()).payload(formData).build()).build();
    }

    private void logResourceOwnerOAuthContextBeforeUpdate(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Update OAuth Context for resourceOwnerId %s", (Object)resourceOwnerOAuthContext.getResourceOwnerId());
        }
    }

    private TokenResponseProcessor processTokenUrlResponse(Event tokenUrlResponse) throws TokenNotFoundException, TransformerException {
        TokenResponseProcessor tokenResponseProcessor = TokenResponseProcessor.createAuthorizationCodeProcessor(this.tokenResponseConfiguration, this.getMuleContext().getExpressionManager());
        tokenResponseProcessor.process(tokenUrlResponse);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponseProcessor.getAccessToken(), tokenResponseProcessor.getRefreshToken(), tokenResponseProcessor.getExpiresIn()});
        }
        if (!this.tokenResponseContentIsValid(tokenResponseProcessor)) {
            throw new TokenNotFoundException(tokenUrlResponse, tokenResponseProcessor);
        }
        return tokenResponseProcessor;
    }

    private void updateResourceOwnerState(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String newState, TokenResponseProcessor tokenResponseProcessor) {
        resourceOwnerOAuthContext.setAccessToken(tokenResponseProcessor.getAccessToken());
        if (tokenResponseProcessor.getRefreshToken() != null) {
            resourceOwnerOAuthContext.setRefreshToken(tokenResponseProcessor.getRefreshToken());
        }
        resourceOwnerOAuthContext.setExpiresIn(tokenResponseProcessor.getExpiresIn());
        if (newState != null) {
            resourceOwnerOAuthContext.setState(newState);
        }
        Map<String, Object> customResponseParameters = tokenResponseProcessor.getCustomResponseParameters();
        for (String paramName : customResponseParameters.keySet()) {
            Object paramValue = customResponseParameters.get(paramName);
            if (paramValue == null) continue;
            resourceOwnerOAuthContext.getTokenResponseParameters().put(paramName, paramValue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New OAuth State for resourceOwnerId %s is: accessToken(%s), refreshToken(%s), expiresIn(%s), state(%s)", new Object[]{resourceOwnerOAuthContext.getResourceOwnerId(), resourceOwnerOAuthContext.getAccessToken(), org.mule.runtime.core.util.StringUtils.isBlank((String)resourceOwnerOAuthContext.getRefreshToken()) ? "Not issued" : resourceOwnerOAuthContext.getRefreshToken(), resourceOwnerOAuthContext.getExpiresIn(), resourceOwnerOAuthContext.getState()});
        }
    }

    @Override
    public void doRefreshToken(Event currentEvent, ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        try {
            Event muleEvent = Event.builder((Event)currentEvent).message(InternalMessage.builder((InternalMessage)currentEvent.getMessage()).outboundProperties(Collections.emptyMap()).build()).session((MuleSession)new DefaultMuleSession(currentEvent.getSession())).build();
            String userRefreshToken = resourceOwnerOAuthContext.getRefreshToken();
            if (userRefreshToken == null) {
                throw new DefaultMuleException(CoreMessages.createStaticMessage((String)"The user with user id %s has no refresh token in his OAuth state so we can't execute the refresh token call", (Object[])new Object[]{resourceOwnerOAuthContext.getResourceOwnerId()}));
            }
            muleEvent = this.setMapPayloadWithRefreshTokenRequestParameters(muleEvent, userRefreshToken);
            Event refreshTokenResponse = this.invokeTokenUrl(muleEvent);
            this.logResourceOwnerOAuthContextBeforeUpdate(resourceOwnerOAuthContext);
            TokenResponseProcessor tokenResponseProcessor = this.processTokenUrlResponse(refreshTokenResponse);
            this.updateResourceOwnerState(resourceOwnerOAuthContext, null, tokenResponseProcessor);
        }
        catch (TokenNotFoundException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Access token was not found from the refresh token oauth call"), (Throwable)e);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private class NoAuthorizationCodeException
    extends Exception {
        private NoAuthorizationCodeException() {
        }
    }
}

