/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.oauth2.internal.ParameterExtractor;
import org.mule.runtime.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenResponseProcessor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TokenResponseConfiguration tokenResponseConfiguration;
    private final ExtendedExpressionManager expressionManager;
    private final boolean retrieveRefreshToken;
    private String accessToken;
    private String refreshToken;
    private String expiresIn;
    private Map<String, Object> customResponseParameters;

    public static TokenResponseProcessor createAuthorizationCodeProcessor(TokenResponseConfiguration tokenResponseConfiguration, ExtendedExpressionManager expressionManager) {
        return new TokenResponseProcessor(tokenResponseConfiguration, expressionManager, true);
    }

    public static TokenResponseProcessor createClientCredentialsProcessor(TokenResponseConfiguration tokenResponseConfiguration, ExtendedExpressionManager expressionManager) {
        return new TokenResponseProcessor(tokenResponseConfiguration, expressionManager, false);
    }

    private TokenResponseProcessor(TokenResponseConfiguration tokenResponseConfiguration, ExtendedExpressionManager expressionManager, boolean retrieveRefreshToken) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
        this.expressionManager = expressionManager;
        this.retrieveRefreshToken = retrieveRefreshToken;
    }

    public void process(Event muleEvent) {
        Event.Builder builder = Event.builder((Event)muleEvent);
        this.accessToken = this.expressionManager.parse(this.tokenResponseConfiguration.getAccessToken(), muleEvent, builder, null);
        muleEvent = builder.build();
        String string = this.accessToken = this.isEmpty(this.accessToken) ? null : this.accessToken;
        if (this.accessToken == null) {
            this.logger.error("Could not extract access token from token URL. Expressions used to retrieve access token was " + this.tokenResponseConfiguration.getAccessToken());
        }
        if (this.retrieveRefreshToken) {
            builder = Event.builder((Event)muleEvent);
            this.refreshToken = this.expressionManager.parse(this.tokenResponseConfiguration.getRefreshToken(), muleEvent, builder, null);
            muleEvent = builder.build();
            this.refreshToken = this.isEmpty(this.refreshToken) ? null : this.refreshToken;
        }
        builder = Event.builder((Event)muleEvent);
        this.expiresIn = this.expressionManager.parse(this.tokenResponseConfiguration.getExpiresIn(), muleEvent, builder, null);
        muleEvent = builder.build();
        this.customResponseParameters = new HashMap<String, Object>();
        for (ParameterExtractor parameterExtractor : this.tokenResponseConfiguration.getParameterExtractors()) {
            builder = Event.builder((Event)muleEvent);
            this.customResponseParameters.put(parameterExtractor.getParamName(), this.expressionManager.evaluate(parameterExtractor.getValue(), muleEvent, builder, null));
            muleEvent = builder.build();
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public Map<String, Object> getCustomResponseParameters() {
        return this.customResponseParameters;
    }

    private boolean isEmpty(String value) {
        return value == null || StringUtils.isEmpty((String)value) || "null".equals(value);
    }
}

