/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.clientcredentials;

import java.util.HashMap;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.mule.module.oauth2.internal.AbstractTokenRequestHandler;
import org.mule.module.oauth2.internal.ApplicationCredentials;
import org.mule.module.oauth2.internal.TokenResponseProcessor;
import org.mule.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;
import org.mule.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.mule.module.oauth2.internal.tokenmanager.TokenManagerConfig;
import org.mule.transport.NullPayload;

public class ClientCredentialsTokenRequestHandler
extends AbstractTokenRequestHandler {
    private String scopes;
    private ApplicationCredentials applicationCredentials;
    private TokenResponseConfiguration tokenResponseConfiguration = new TokenResponseConfiguration();
    private TokenManagerConfig tokenManager;

    public void setApplicationCredentials(ApplicationCredentials applicationCredentials) {
        this.applicationCredentials = applicationCredentials;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setTokenResponseConfiguration(TokenResponseConfiguration tokenResponseConfiguration) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
    }

    private void setMapPayloadWithTokenRequestParameters(MuleEvent event) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("client_id", this.applicationCredentials.getClientId());
        formData.put("client_secret", this.applicationCredentials.getClientSecret());
        formData.put("grant_type", "client_credentials");
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        event.getMessage().setPayload(formData);
    }

    public void refreshAccessToken() throws MuleException {
        DefaultMuleEvent accessTokenEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getMuleContext()), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)new Flow("test", this.getMuleContext()));
        this.setMapPayloadWithTokenRequestParameters((MuleEvent)accessTokenEvent);
        MuleEvent response = this.invokeTokenUrl((MuleEvent)accessTokenEvent);
        TokenResponseProcessor tokenResponseProcessor = TokenResponseProcessor.createClientCredentialsProcessor(this.tokenResponseConfiguration, this.getMuleContext().getExpressionManager());
        tokenResponseProcessor.process(response);
        ResourceOwnerOAuthContext defaultUserState = this.tokenManager.getConfigOAuthContext().getContextForResourceOwner("default");
        defaultUserState.setAccessToken(tokenResponseProcessor.getAccessToken());
        defaultUserState.setExpiresIn(tokenResponseProcessor.getExpiresIn());
        Map<String, Object> customResponseParameters = tokenResponseProcessor.getCustomResponseParameters();
        for (String paramName : customResponseParameters.keySet()) {
            defaultUserState.getTokenResponseParameters().put(paramName, customResponseParameters.get(paramName));
        }
        this.tokenManager.getConfigOAuthContext().updateResourceOwnerOAuthContext(defaultUserState);
    }

    public void setTokenManager(TokenManagerConfig tokenManager) {
        this.tokenManager = tokenManager;
    }
}

