/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.transformers;

import com.mongodb.DBObject;
import java.lang.reflect.Method;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.mongo.MongoCloudConnector;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class JsonToDbobjectTransformer
extends AbstractTransformer
implements DiscoverableTransformer {
    private int weighting = 6;

    public JsonToDbobjectTransformer() {
        this.registerSourceType(DataTypeFactory.create(String.class));
        try {
            Method method = MongoCloudConnector.class.getMethod("jsonToDbobject", String.class);
            DataType dataType = DataTypeFactory.createFromReturnType((Method)method);
            this.setReturnDataType(dataType);
        }
        catch (NoSuchMethodException _x) {
            throw new RuntimeException("Unable to find method jsonToDbobject");
        }
        this.setName("JsonToDbobjectTransformer");
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        DBObject result = null;
        try {
            result = MongoCloudConnector.jsonToDbobject((String)src);
        }
        catch (Exception exception) {
            throw new TransformerException(CoreMessages.transformFailed((String)src.getClass().getName(), (String)"com.mongodb.DBObject"), (Transformer)this, (Throwable)exception);
        }
        return result;
    }

    public int getPriorityWeighting() {
        return this.weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }
}

