/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mule.module.mongo.tools.BackupUtils;

public class ZipUtils {
    private static final String ZIP_EXTENSION = "zip";

    private ZipUtils() {
    }

    public static void zipDirectory(String dbDumpPath) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(dbDumpPath + ".zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        File dumpDirectory = new File(dbDumpPath);
        ZipUtils.addDirectory(zipOutputStream, dumpDirectory);
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDirectory(ZipOutputStream zipOutputStream, File dumpDirectory) throws IOException {
        File[] files;
        for (File file : files = dumpDirectory.listFiles()) {
            if (file.isDirectory()) {
                ZipUtils.addDirectory(zipOutputStream, file);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                int length;
                byte[] buffer = new byte[1024];
                zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
                while ((length = fileInputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, length);
                }
                zipOutputStream.closeEntry();
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    public static boolean isZipFile(File file) {
        return BackupUtils.hasExtension(file, ZIP_EXTENSION);
    }
}

