/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;
import org.mule.module.mongo.api.MongoClient;
import org.mule.module.mongo.tools.BackupUtils;
import org.mule.module.mongo.tools.RestoreFile;
import org.mule.module.mongo.tools.ZipUtils;
import org.mule.util.FileUtils;

public class MongoRestoreDirectory
implements Callable<Void> {
    private MongoClient mongoClient;
    private boolean drop;
    private boolean oplogReplay;
    private String inputPath;
    private String database;

    @Override
    public Void call() throws Exception {
        this.restore();
        return null;
    }

    private void restore() throws IOException {
        Validate.notNull((Object)this.inputPath);
        List<RestoreFile> restoreFiles = this.getRestoreFiles(this.inputPath);
        ArrayList<RestoreFile> oplogRestores = new ArrayList<RestoreFile>();
        for (RestoreFile restoreFile : restoreFiles) {
            if (!this.isOplog(restoreFile.getCollection())) {
                if (this.drop && !BackupUtils.isSystemCollection(restoreFile.getCollection())) {
                    this.mongoClient.dropCollection(restoreFile.getCollection());
                }
                DBCollection dbCollection = this.mongoClient.getCollection(restoreFile.getCollection());
                List<DBObject> dbObjects = restoreFile.getCollectionObjects();
                if (BackupUtils.isUserCollection(restoreFile.getCollection())) {
                    for (DBObject currentUser : dbCollection.find()) {
                        if (dbObjects.contains(currentUser)) continue;
                        dbCollection.remove(currentUser);
                    }
                }
                for (DBObject dbObject : dbObjects) {
                    dbCollection.save(dbObject);
                }
                continue;
            }
            oplogRestores.add(restoreFile);
        }
        if (this.oplogReplay && !oplogRestores.isEmpty()) {
            for (RestoreFile oplogRestore : oplogRestores) {
                this.mongoClient.executeComamnd((DBObject)new BasicDBObject("applyOps", (Object)this.filterOplogForDatabase(oplogRestore).toArray()));
            }
        }
    }

    private List<DBObject> filterOplogForDatabase(RestoreFile oplogFile) throws IOException {
        List<DBObject> oplogEntries = oplogFile.getCollectionObjects();
        ArrayList<DBObject> dbOplogEntries = new ArrayList<DBObject>();
        for (DBObject oplogEntry : oplogEntries) {
            if (!((String)oplogEntry.get("ns")).startsWith(this.database + ".")) continue;
            dbOplogEntries.add(oplogEntry);
        }
        return dbOplogEntries;
    }

    private void processRestoreFiles(File input, List<RestoreFile> restoreFiles) throws IOException {
        File unzippedFolder;
        if (ZipUtils.isZipFile(input)) {
            unzippedFolder = new File(BackupUtils.removeExtension(input.getPath()));
            FileUtils.unzip((File)input, (File)unzippedFolder);
        } else {
            unzippedFolder = input;
        }
        if (unzippedFolder.isDirectory()) {
            for (File file : unzippedFolder.listFiles()) {
                this.processRestoreFiles(file, restoreFiles);
            }
        } else if (BackupUtils.isBsonFile(unzippedFolder)) {
            restoreFiles.add(new RestoreFile(unzippedFolder));
        }
    }

    private List<RestoreFile> getRestoreFiles(String inputPath) throws IOException {
        ArrayList<RestoreFile> restoreFiles = new ArrayList<RestoreFile>();
        this.processRestoreFiles(new File(inputPath), restoreFiles);
        Collections.sort(restoreFiles);
        return restoreFiles;
    }

    private boolean isOplog(String collection) {
        return collection.startsWith("oplog");
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setOplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

