/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.DB;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.mule.module.mongo.tools.AbstractMongoUtility;
import org.mule.module.mongo.tools.IncrementalOplogDump;

public class IncrementalMongoDump
extends AbstractMongoUtility {
    private Map<String, DB> dbs = new HashMap<String, DB>();
    private String incrementalTimestampFile;

    public void dump(String outputDirectory, String database) throws IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        IncrementalOplogDump incrementalOplogDump = new IncrementalOplogDump();
        incrementalOplogDump.setOutputDirectory(outputDirectory);
        incrementalOplogDump.setDatabase(database);
        incrementalOplogDump.setIncrementalTimestampFile(this.incrementalTimestampFile);
        incrementalOplogDump.setDBs(this.dbs);
        Future<Void> future = executor.submit(incrementalOplogDump);
        this.propagateException(future);
    }

    public void addDB(DB db) {
        this.dbs.put(db.getName(), db);
    }

    public void setIncrementalTimestampFile(String incrementalTimestampFile) {
        this.incrementalTimestampFile = incrementalTimestampFile;
    }
}

