/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.DBObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.bson.BSON;
import org.bson.BSONObject;
import org.mule.module.mongo.tools.DumpWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonDumpWriter
extends DumpWriter {
    private static final String BSON_EXTENSION = "bson";
    private static final Logger logger = LoggerFactory.getLogger(BsonDumpWriter.class);

    public BsonDumpWriter(String outputDirectory, String database) {
        super(outputDirectory, database);
    }

    public BsonDumpWriter(String outputDirectory) {
        super(outputDirectory);
    }

    @Override
    public String getExtension() {
        return BSON_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(String collection, DBObject dbObject) throws IOException {
        FileOutputStream outputStream = null;
        File outputFile = new File(this.getFilePath(collection));
        if (!outputFile.getParentFile().mkdirs()) {
            logger.info("Couldn't create dir: " + outputFile.getParentFile());
        }
        try {
            outputStream = new FileOutputStream(outputFile, true);
            outputStream.write(BSON.encode((BSONObject)dbObject));
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

