/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.module.mongo.adapters.MongoCloudConnectorConnectionIdentifierAdapter;
import org.mule.module.mongo.connection.ConnectionManager;
import org.mule.module.mongo.connection.UnableToAcquireConnectionException;
import org.mule.module.mongo.connection.UnableToReleaseConnectionException;
import org.mule.module.mongo.connectivity.MongoCloudConnectorConnectionKey;
import org.mule.module.mongo.processors.ConnectivityProcessor;
import org.mule.security.oauth.callback.ProcessCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoCloudConnectorManagedConnectionProcessInterceptor<T>
extends ExpressionEvaluatorSupport
implements ProcessInterceptor<T, MongoCloudConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(MongoCloudConnectorManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<MongoCloudConnectorConnectionKey, MongoCloudConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, MongoCloudConnectorConnectionIdentifierAdapter> next;

    public MongoCloudConnectorManagedConnectionProcessInterceptor(ProcessInterceptor<T, MongoCloudConnectorConnectionIdentifierAdapter> next, ConnectionManager<MongoCloudConnectorConnectionKey, MongoCloudConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, MongoCloudConnectorConnectionIdentifierAdapter> processCallback, MongoCloudConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object connectivityProcessor;
        MongoCloudConnectorConnectionIdentifierAdapter connection = null;
        MongoCloudConnectorConnectionKey key = null;
        if (this.hasConnectionKeysOverride(messageProcessor).booleanValue()) {
            connectivityProcessor = (ConnectivityProcessor)messageProcessor;
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_usernameType"), null, connectivityProcessor.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_passwordType"), null, connectivityProcessor.getPassword());
            String _transformedDatabase = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_databaseType"), null, connectivityProcessor.getDatabase());
            if (_transformedDatabase == null) {
                throw new UnableToAcquireConnectionException("Parameter database in method connect can't be null because is not @Optional");
            }
            key = new MongoCloudConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedDatabase);
        } else {
            key = this.connectionManager.getEvaluatedConnectionKey(event);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            connectivityProcessor = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)connectivityProcessor;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    private Boolean hasConnectionKeysOverride(MessageProcessor messageProcessor) {
        if (messageProcessor == null || !(messageProcessor instanceof ConnectivityProcessor)) {
            return false;
        }
        ConnectivityProcessor connectivityProcessor = (ConnectivityProcessor)messageProcessor;
        if (connectivityProcessor.getUsername() != null) {
            return true;
        }
        if (connectivityProcessor.getDatabase() != null) {
            return true;
        }
        return false;
    }

    public T execute(ProcessCallback<T, MongoCloudConnectorConnectionIdentifierAdapter> processCallback, MongoCloudConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

