/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.module.mongo.adapters.MongoCloudConnectorConnectionIdentifierAdapter;
import org.mule.module.mongo.connectivity.MongoCloudConnectorConnectionKey;
import org.mule.module.mongo.connectivity.MongoCloudConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoCloudConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(MongoCloudConnectorConnectionFactory.class);
    private MongoCloudConnectorConnectionManager connectionManager;

    public MongoCloudConnectorConnectionFactory(MongoCloudConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof MongoCloudConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.module.mongo.connectivity.MongoCloudConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        MongoCloudConnectorConnectionIdentifierAdapter connector = new MongoCloudConnectorConnectionIdentifierAdapter();
        connector.setHost(this.connectionManager.getHost());
        connector.setPort(this.connectionManager.getPort());
        connector.setConnectionsPerHost(this.connectionManager.getConnectionsPerHost());
        connector.setThreadsAllowedToBlockForConnectionMultiplier(this.connectionManager.getThreadsAllowedToBlockForConnectionMultiplier());
        connector.setMaxWaitTime(this.connectionManager.getMaxWaitTime());
        connector.setConnectTimeout(this.connectionManager.getConnectTimeout());
        connector.setSocketTimeout(this.connectionManager.getSocketTimeout());
        connector.setAutoConnectRetry(this.connectionManager.getAutoConnectRetry());
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((MongoCloudConnectorConnectionKey)key).getUsername(), ((MongoCloudConnectorConnectionKey)key).getPassword(), ((MongoCloudConnectorConnectionKey)key).getDatabase());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof MongoCloudConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.module.mongo.connectivity.MongoCloudConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof MongoCloudConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.module.mongo.adapters.MongoCloudConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((MongoCloudConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((MongoCloudConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((MongoCloudConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof MongoCloudConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.module.mongo.adapters.MongoCloudConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((MongoCloudConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof MongoCloudConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof MongoCloudConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((MongoCloudConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((MongoCloudConnectorConnectionIdentifierAdapter)obj).connect(((MongoCloudConnectorConnectionKey)key).getUsername(), ((MongoCloudConnectorConnectionKey)key).getPassword(), ((MongoCloudConnectorConnectionKey)key).getDatabase());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

