/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bson.BSONObject;
import org.bson.types.BasicBSONList;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.param.Payload;
import org.mule.module.mongo.api.DBObjects;
import org.mule.module.mongo.api.IndexOrder;
import org.mule.module.mongo.api.MongoClient;
import org.mule.module.mongo.api.MongoClientAdaptor;
import org.mule.module.mongo.api.MongoClientImpl;
import org.mule.module.mongo.api.MongoCollection;
import org.mule.module.mongo.api.WriteConcern;
import org.mule.module.mongo.tools.IncrementalMongoDump;
import org.mule.module.mongo.tools.MongoDump;
import org.mule.module.mongo.tools.MongoRestore;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoCloudConnector {
    private static final Logger logger = LoggerFactory.getLogger(MongoCloudConnector.class);
    private static final String CAPPED_DEFAULT_VALUE = "false";
    private static final String WRITE_CONCERN_DEFAULT_VALUE = "DATABASE_DEFAULT";
    private static final String BACKUP_THREADS = "5";
    private static final String DEFAULT_OUTPUT_DIRECTORY = "dump";
    private String host;
    private int port;
    public Integer connectionsPerHost;
    public Integer threadsAllowedToBlockForConnectionMultiplier;
    public Integer maxWaitTime;
    private Integer connectTimeout;
    private Integer socketTimeout;
    private Boolean autoConnectRetry;
    private String database;
    private Mongo mongo;
    private MongoClient client;

    public WriteResult addUser(String newUsername, String newPassword) {
        return this.client.addUser(newUsername, newPassword);
    }

    public void dropDatabase() {
        this.client.dropDatabase();
    }

    public Collection<String> listCollections() {
        return this.client.listCollections();
    }

    public boolean existsCollection(String collection) {
        return this.client.existsCollection(collection);
    }

    public void dropCollection(String collection) {
        this.client.dropCollection(collection);
    }

    public void createCollection(String collection, boolean capped, Integer maxObjects, Integer size) {
        this.client.createCollection(collection, capped, maxObjects, size);
    }

    public String insertObject(String collection, DBObject dbObject, WriteConcern writeConcern) {
        return this.client.insertObject(collection, dbObject, writeConcern);
    }

    public String insertObjectFromMap(String collection, Map<String, Object> elementAttributes, WriteConcern writeConcern) {
        return this.client.insertObject(collection, (DBObject)DBObjects.adapt(elementAttributes), writeConcern);
    }

    public void updateObjects(String collection, DBObject query, DBObject element, boolean upsert, boolean multi, WriteConcern writeConcern) {
        this.client.updateObjects(collection, query, element, upsert, multi, writeConcern);
    }

    public void updateObjectsUsingQueryMap(String collection, Map<String, Object> queryAttributes, DBObject element, boolean upsert, boolean multi, WriteConcern writeConcern) {
        this.client.updateObjects(collection, (DBObject)DBObjects.adapt(queryAttributes), element, upsert, multi, writeConcern);
    }

    public void updateObjectsUsingMap(String collection, Map<String, Object> queryAttributes, Map<String, Object> elementAttributes, boolean upsert, boolean multi, WriteConcern writeConcern) {
        this.client.updateObjects(collection, (DBObject)DBObjects.adapt(queryAttributes), (DBObject)DBObjects.adapt(elementAttributes), upsert, multi, writeConcern);
    }

    public void updateObjectsByFunction(String collection, String function, DBObject query, DBObject element, boolean upsert, boolean multi, WriteConcern writeConcern) {
        DBObject functionDbObject = DBObjects.fromFunction(function, element);
        this.client.updateObjects(collection, query, functionDbObject, upsert, multi, writeConcern);
    }

    public void updateObjectsByFunctionUsingMap(String collection, String function, Map<String, Object> queryAttributes, Map<String, Object> elementAttributes, boolean upsert, boolean multi, WriteConcern writeConcern) {
        DBObject functionDbObject = DBObjects.fromFunction(function, (DBObject)DBObjects.adapt(elementAttributes));
        this.client.updateObjects(collection, (DBObject)DBObjects.adapt(queryAttributes), functionDbObject, upsert, multi, writeConcern);
    }

    public void saveObject(String collection, DBObject element, WriteConcern writeConcern) {
        this.client.saveObject(collection, DBObjects.from(element), writeConcern);
    }

    public void saveObjectFromMap(String collection, Map<String, Object> elementAttributes, WriteConcern writeConcern) {
        this.client.saveObject(collection, (DBObject)DBObjects.adapt(elementAttributes), writeConcern);
    }

    public void removeObjects(String collection, DBObject query, WriteConcern writeConcern) {
        this.client.removeObjects(collection, query, writeConcern);
    }

    public void removeObjectsUsingQueryMap(String collection, Map<String, Object> queryAttributes, WriteConcern writeConcern) {
        this.client.removeObjects(collection, (DBObject)DBObjects.adapt(queryAttributes), writeConcern);
    }

    public Iterable<DBObject> mapReduceObjects(String collection, String mapFunction, String reduceFunction, String outputCollection) {
        return this.client.mapReduceObjects(collection, mapFunction, reduceFunction, outputCollection);
    }

    public long countObjects(String collection, DBObject query) {
        return this.client.countObjects(collection, query);
    }

    public long countObjectsUsingQueryMap(String collection, Map<String, Object> queryAttributes) {
        return this.client.countObjects(collection, (DBObject)DBObjects.adapt(queryAttributes));
    }

    public Iterable<DBObject> findObjects(String collection, DBObject query, List<String> fields, Integer numToSkip, Integer limit, DBObject sortBy) {
        return this.client.findObjects(collection, query, fields, numToSkip, limit, sortBy);
    }

    public Iterable<DBObject> findObjectsUsingQueryMap(String collection, Map<String, Object> queryAttributes, List<String> fields, Integer numToSkip, Integer limit, DBObject sortBy) {
        return this.client.findObjects(collection, (DBObject)DBObjects.adapt(queryAttributes), fields, numToSkip, limit, sortBy);
    }

    public DBObject findOneObject(String collection, DBObject query, List<String> fields, Boolean failOnNotFound) {
        return this.client.findOneObject(collection, query, fields, failOnNotFound);
    }

    public DBObject findOneObjectUsingQueryMap(String collection, Map<String, Object> queryAttributes, List<String> fields, Boolean failOnNotFound) {
        return this.client.findOneObject(collection, (DBObject)DBObjects.adapt(queryAttributes), fields, failOnNotFound);
    }

    public void createIndex(String collection, String field, IndexOrder order) {
        this.client.createIndex(collection, field, order);
    }

    public void dropIndex(String collection, String index) {
        this.client.dropIndex(collection, index);
    }

    public Collection<DBObject> listIndices(String collection) {
        return this.client.listIndices(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBObject createFileFromPayload(@Payload Object payload, String filename, String contentType, DBObject metadata) throws IOException {
        InputStream stream = this.toStream(payload);
        try {
            DBObject dBObject = this.client.createFile(stream, filename, contentType, metadata);
            return dBObject;
        }
        finally {
            stream.close();
        }
    }

    private InputStream toStream(Object content) throws FileNotFoundException {
        if (content instanceof InputStream) {
            return (InputStream)content;
        }
        if (content instanceof byte[]) {
            return new ByteArrayInputStream((byte[])content);
        }
        if (content instanceof File) {
            return new FileInputStream((File)content);
        }
        throw new IllegalArgumentException("Content " + content + " is not supported");
    }

    public Iterable<DBObject> findFiles(DBObject query) {
        return this.client.findFiles(DBObjects.from(query));
    }

    public Iterable<DBObject> findFilesUsingQueryMap(Map<String, Object> queryAttributes) {
        return this.client.findFiles((DBObject)DBObjects.adapt(queryAttributes));
    }

    public DBObject findOneFile(DBObject query) {
        return this.client.findOneFile(DBObjects.from(query));
    }

    public DBObject findOneFileUsingQueryMap(Map<String, Object> queryAttributes) {
        return this.client.findOneFile((DBObject)DBObjects.adapt(queryAttributes));
    }

    public InputStream getFileContent(DBObject query) {
        return this.client.getFileContent(DBObjects.from(query));
    }

    public InputStream getFileContentUsingQueryMap(Map<String, Object> queryAttributes) {
        return this.client.getFileContent((DBObject)DBObjects.adapt(queryAttributes));
    }

    public Iterable<DBObject> listFiles(DBObject query) {
        return this.client.listFiles(DBObjects.from(query));
    }

    public Iterable<DBObject> listFilesUsingQueryMap(Map<String, Object> queryAttributes) {
        return this.client.listFiles((DBObject)DBObjects.adapt(queryAttributes));
    }

    public void removeFiles(DBObject query) {
        this.client.removeFiles(DBObjects.from(query));
    }

    public void removeFilesUsingQueryMap(Map<String, Object> queryAttributes) {
        this.client.removeFiles((DBObject)DBObjects.adapt(queryAttributes));
    }

    public DBObject executeCommand(String commandName, String commandValue) {
        DBObject dbObject = DBObjects.fromCommand(commandName, commandValue);
        return this.client.executeComamnd(dbObject);
    }

    public void dump(String outputDirectory, String outputName, boolean zip, boolean oplog, int threads) throws IOException {
        MongoDump mongoDump = new MongoDump(this.client);
        mongoDump.setZip(zip);
        if (oplog) {
            mongoDump.setOplog(oplog);
            mongoDump.addDB(this.mongo.getDB("admin"));
            mongoDump.addDB(this.mongo.getDB("local"));
        }
        mongoDump.dump(outputDirectory, this.database, outputName != null ? outputName : this.database, threads);
    }

    public void incrementalDump(String outputDirectory, String incrementalTimestampFile) throws IOException {
        IncrementalMongoDump incrementalMongoDump = new IncrementalMongoDump();
        incrementalMongoDump.addDB(this.mongo.getDB("admin"));
        incrementalMongoDump.addDB(this.mongo.getDB("local"));
        incrementalMongoDump.setIncrementalTimestampFile(incrementalTimestampFile);
        incrementalMongoDump.dump(outputDirectory, this.database);
    }

    public void restore(String inputPath, boolean drop, boolean oplogReplay) throws IOException {
        MongoRestore mongoRestore = new MongoRestore(this.client, this.database);
        mongoRestore.setDrop(drop);
        mongoRestore.setOplogReplay(oplogReplay);
        mongoRestore.restore(inputPath);
    }

    public void startConsistentRequest() {
        this.client.requestStart();
    }

    public void endConsistentRequest() {
        this.client.requestDone();
    }

    @Transformer(sourceTypes={String.class})
    public static DBObject jsonToDbobject(String input) {
        DBObject o = null;
        BSONObject bsonObj = null;
        Object obj = JSON.parse((String)input);
        if (obj instanceof BasicDBList) {
            BasicDBList basicList = (BasicDBList)obj;
            if (basicList.size() > 1) {
                for (int i = 0; i < basicList.size(); ++i) {
                    bsonObj = (BSONObject)basicList.get(0);
                    Map entries = bsonObj.toMap();
                    if (i > 0) {
                        o.putAll(entries);
                        continue;
                    }
                    o = new BasicDBObject(entries);
                }
            }
        } else {
            o = (DBObject)obj;
        }
        return o;
    }

    @Transformer(sourceTypes={DBObject.class})
    public static String dbobjectToJson(DBObject input) {
        return JSON.serialize((Object)input);
    }

    @Transformer(sourceTypes={BasicBSONList.class})
    public static String bsonListToJson(BasicBSONList input) {
        return JSON.serialize((Object)input);
    }

    @Transformer(sourceTypes={MongoCollection.class})
    public static String mongoCollectionToJson(MongoCollection input) {
        return JSON.serialize((Object)input);
    }

    @Transformer(sourceTypes={DBObject.class})
    public static Map dbObjectToMap(DBObject input) {
        return input.toMap();
    }

    public void connect(String username, String password, String database) throws ConnectionException {
        try {
            this.mongo = new com.mongodb.MongoClient(this.getMongoClientURI(username, password, database));
            this.client = new MongoClientImpl(this.getDatabase(this.mongo, username, password, database));
            DB db = this.mongo.getDB(database);
            db.getStats();
        }
        catch (UnknownHostException ex) {
            logger.info(ex.getMessage(), (Throwable)ex);
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN_HOST, ex.getLocalizedMessage(), ex.getMessage(), ex.getCause());
        }
        catch (MongoException.Network mn) {
            logger.info(mn.getMessage(), (Throwable)mn);
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, mn.getLocalizedMessage(), mn.getMessage(), mn.getCause());
        }
        catch (IllegalArgumentException ia) {
            logger.info(ia.getMessage(), (Throwable)ia);
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, ia.getLocalizedMessage(), ia.getMessage(), ia.getCause());
        }
    }

    private MongoClientURI getMongoClientURI(String username, String password, String database) {
        LinkedList<String> hostsWithPort = new LinkedList<String>();
        for (String hostname : this.host.split(",\\s?")) {
            hostsWithPort.add(hostname + ":" + this.port);
        }
        return new MongoClientURI("mongodb://" + StringUtils.join(hostsWithPort, (String)",") + "/" + database, this.getMongoOptions(database));
    }

    private MongoClientOptions.Builder getMongoOptions(String database) {
        MongoClientOptions.Builder options = MongoClientOptions.builder();
        if (this.connectionsPerHost != null) {
            options.connectionsPerHost(this.connectionsPerHost.intValue());
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != null) {
            options.threadsAllowedToBlockForConnectionMultiplier(this.threadsAllowedToBlockForConnectionMultiplier.intValue());
        }
        if (this.maxWaitTime != null) {
            options.maxWaitTime(this.maxWaitTime.intValue());
        }
        if (this.connectTimeout != null) {
            options.connectTimeout(this.connectTimeout.intValue());
        }
        if (this.socketTimeout != null) {
            options.socketTimeout(this.socketTimeout.intValue());
        }
        if (this.autoConnectRetry != null) {
            options.autoConnectRetry(this.autoConnectRetry.booleanValue());
        }
        if (database != null) {
            this.database = database;
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                logger.warn("Failed to properly close client: " + this.client, (Throwable)e);
            }
            finally {
                this.client = null;
            }
        }
        if (this.mongo != null) {
            try {
                this.mongo.close();
            }
            catch (Exception e) {
                logger.warn("Failed to properly close mongo: " + this.mongo, (Throwable)e);
            }
            finally {
                this.mongo = null;
            }
        }
    }

    public boolean isConnected() {
        return this.client != null && this.mongo != null && this.mongo.getConnector().isOpen();
    }

    public String connectionId() {
        return this.mongo == null ? "n/a" : this.mongo.toString();
    }

    private DB getDatabase(Mongo mongo, String username, String password, String database) throws ConnectionException {
        DB db = mongo.getDB(database);
        if (StringUtils.isNotBlank((String)password)) {
            Validate.notNull((Object)username, (String)"Username must not be null if password is set");
            if (!db.isAuthenticated() && !db.authenticate(username, password.toCharArray())) {
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, "Couldn't connect with the given credentials");
            }
        }
        return db;
    }

    protected MongoClient adaptClient(MongoClient client) {
        return MongoClientAdaptor.adapt(client);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public Integer getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public void setConnectionsPerHost(Integer connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public Integer getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(Integer threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }

    public Integer getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(Integer maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Boolean getAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    public void setAutoConnectRetry(Boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }
}

