/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.management.agent.ConfigurableJMXAuthenticator;
import org.mule.runtime.module.management.agent.JmxApplicationAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePasswordJmxAuthenticator
implements JMXAuthenticator,
ConfigurableJMXAuthenticator {
    protected static final Logger logger = LoggerFactory.getLogger(JmxApplicationAgent.class);
    private Map<String, Object> credentials = new HashMap<String, Object>();

    @Override
    public Subject authenticate(Object authToken) {
        if (authToken == null) {
            throw new SecurityException("No authentication token available");
        }
        if (!(authToken instanceof String[]) || ((String[])authToken).length != 2) {
            throw new SecurityException("Unsupported credentials format");
        }
        String[] authentication = (String[])authToken;
        String username = StringUtils.defaultString((String)authentication[0]);
        String password = StringUtils.defaultString((String)authentication[1]);
        if (!this.credentials.containsKey(username)) {
            throw new SecurityException("Unauthenticated user: " + username);
        }
        Object pass = this.credentials.get(username);
        if (!password.equals(pass == null ? "" : pass.toString())) {
            throw new SecurityException("Invalid password");
        }
        HashSet<JMXPrincipal> principals = new HashSet<JMXPrincipal>();
        principals.add(new JMXPrincipal(username));
        return new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    public void setCredentials(Map<String, String> newCredentials) {
        this.credentials.clear();
        if (newCredentials == null || newCredentials.isEmpty()) {
            logger.warn("Credentials cache has been purged, remote access will no longer be available");
        } else {
            this.credentials.putAll(newCredentials);
        }
    }

    @Override
    public void configure(Map newCredentials) {
        this.setCredentials(newCredentials);
    }
}

