/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.mbean;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.NetworkUtils;
import org.mule.runtime.core.util.StringMessageUtils;
import org.mule.runtime.module.management.mbean.MuleServiceMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleService
implements MuleServiceMBean {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String version;
    private String vendor;
    private String jdk;
    private String host;
    private String ip;
    private String os;
    private String buildNumber;
    private String buildDate;
    private String copyright = "Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com";
    private String license;
    private MuleContext muleContext;

    public MuleService(MuleContext muleContext) {
        this.muleContext = muleContext;
        String patch = System.getProperty("sun.os.patch.level", null);
        this.jdk = System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")";
        this.os = System.getProperty("os.name");
        if (patch != null && !"unknown".equalsIgnoreCase(patch)) {
            this.os = this.os + " - " + patch;
        }
        this.os = this.os + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")";
        this.buildNumber = MuleManifest.getBuildNumber();
        this.buildDate = MuleManifest.getBuildDate();
        try {
            InetAddress iad = NetworkUtils.getLocalHost();
            this.host = iad.getCanonicalHostName();
            this.ip = iad.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInitialised() {
        return this.muleContext != null && this.muleContext.isInitialised();
    }

    @Override
    public boolean isStopped() {
        return this.muleContext != null && !this.muleContext.isStarted();
    }

    @Override
    public Date getStartTime() {
        if (!this.isStopped()) {
            return new Date(this.muleContext.getStartDate());
        }
        return null;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = MuleManifest.getProductVersion();
            if (this.version == null) {
                this.version = "Mule Version Info Not Set";
            }
        }
        return this.version;
    }

    @Override
    public String getVendor() {
        if (this.vendor == null) {
            this.vendor = MuleManifest.getVendorName();
            if (this.vendor == null) {
                this.vendor = "Mule Vendor Info Not Set";
            }
        }
        return this.vendor;
    }

    @Override
    public void start() throws MuleException {
        this.muleContext.start();
    }

    @Override
    public void stop() throws MuleException {
        this.muleContext.stop();
    }

    @Override
    public void dispose() throws MuleException {
        this.muleContext.dispose();
    }

    @Override
    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Override
    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    @Override
    public String getServerId() {
        return this.muleContext.getConfiguration().getId();
    }

    @Override
    public String getHostname() {
        return this.host;
    }

    @Override
    public String getHostIp() {
        return this.ip;
    }

    @Override
    public String getOsVersion() {
        return this.os;
    }

    @Override
    public String getJdkVersion() {
        return this.jdk;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getLicense() {
        if (this.license == null) {
            this.loadEnterpriseLicense();
            if (this.license == null) {
                this.loadCommunityLicense();
            }
            if (this.license == null) {
                this.license = "Failed to load license";
            }
        }
        return this.license;
    }

    private void loadEnterpriseLicense() {
        try {
            this.loadLicense("MULE_EE_LICENSE.txt");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadCommunityLicense() {
        try {
            this.loadLicense("MULE_LICENSE.txt");
        }
        catch (IOException e) {
            this.logger.warn("Failed to load MULE_LICENSE.txt", (Throwable)e);
        }
    }

    private void loadLicense(String licenseFile) throws IOException {
        this.license = IOUtils.getResourceAsString((String)licenseFile, this.getClass());
        this.license = StringMessageUtils.getBoilerPlate((String)this.license, (char)' ', (int)80);
    }

    @Override
    public String getBuildDate() {
        return this.buildDate;
    }

    @Override
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public String getInstanceId() {
        return this.muleContext.getConfiguration().getId();
    }
}

