/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.mbean;

import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.module.management.mbean.FlowConstructService;
import org.mule.runtime.module.management.mbean.FlowConstructServiceMBean;
import org.mule.runtime.module.management.mbean.FlowConstructStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationService
extends FlowConstructService
implements FlowConstructServiceMBean {
    private static Logger LOGGER = LoggerFactory.getLogger(ApplicationService.class);

    public ApplicationService(String type, String name, MuleContext muleContext, FlowConstructStatistics statistics) {
        super(type, name, muleContext, statistics);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        try {
            this.statsName = this.jmxSupport.getObjectName(String.format("%s:type=org.mule.Statistics,%s=%s", this.objectName.getDomain(), this.statistics.getFlowConstructType(), this.jmxSupport.escape(this.getName())));
            if (this.server.isRegistered(this.statsName)) {
                this.server.unregisterMBean(this.statsName);
            }
            this.server.registerMBean(new FlowConstructStats(this.statistics), this.statsName);
        }
        catch (Exception e) {
            LOGGER.error("Error post-registering the MBean", (Throwable)e);
        }
    }
}

