/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.agent;

import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassloaderSwitchingMBeanWrapper
extends StandardMBean
implements MBeanRegistration {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassLoader executionClassLoader;

    public <T> ClassloaderSwitchingMBeanWrapper(T implementation, Class<T> mbeanInterface, ClassLoader executionClassLoader) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
        this.executionClassLoader = executionClassLoader;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.executionClassLoader);
            Object object = super.invoke(actionName, params, signature);
            return object;
        }
        catch (MBeanException mbex) {
            throw mbex;
        }
        catch (ReflectionException rex) {
            throw rex;
        }
        catch (Exception ex) {
            this.logger.error(String.format("MBean operation '%s' failed", actionName), (Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }

    public void setExecutionClassLoader(ClassLoader executionClassLoader) {
        this.executionClassLoader = executionClassLoader;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.getImplementation() instanceof MBeanRegistration) {
            return ((MBeanRegistration)this.getImplementation()).preRegister(server, name);
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (this.getImplementation() instanceof MBeanRegistration) {
            ((MBeanRegistration)this.getImplementation()).postRegister(registrationDone);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.getImplementation() instanceof MBeanRegistration) {
            ((MBeanRegistration)this.getImplementation()).preDeregister();
        }
    }

    @Override
    public void postDeregister() {
        if (this.getImplementation() instanceof MBeanRegistration) {
            ((MBeanRegistration)this.getImplementation()).postDeregister();
        }
    }
}

