/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.support;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import javax.management.ObjectName;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.management.support.JmxLegacySupport;
import org.mule.runtime.module.management.support.JmxModernSupport;
import org.mule.runtime.module.management.support.JmxSupport;
import org.mule.runtime.module.management.support.JmxSupportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoDiscoveryJmxSupportFactory
implements JmxSupportFactory {
    private static final JmxSupportFactory instance = new AutoDiscoveryJmxSupportFactory();
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private JmxSupport jmxSupport;

    protected AutoDiscoveryJmxSupportFactory() {
        boolean jmxModernAvailable = this.isModernSpecAvailable();
        this.jmxSupport = jmxModernAvailable ? new JmxModernSupport() : new JmxLegacySupport();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("JMX support instance is " + this.jmxSupport);
        }
    }

    public static JmxSupportFactory getInstance() {
        return instance;
    }

    @Override
    public JmxSupport getJmxSupport() {
        return this.jmxSupport;
    }

    protected boolean isModernSpecAvailable() {
        Class<ObjectName> clazz = ObjectName.class;
        Method method = ClassUtils.getMethod(clazz, (String)"quote", (Class[])new Class[]{String.class});
        return method != null;
    }

    private Object readResolve() throws ObjectStreamException {
        return instance;
    }
}

