/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.support;

import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.NotificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxRegistrationContext {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<JmxRegistrationContext> contexts = new ThreadLocal();
    private String resolvedDomain;

    private JmxRegistrationContext(MuleContext context) {
        try {
            context.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

                public boolean isBlocking() {
                    return false;
                }

                public void onNotification(MuleContextNotification notification) {
                    MuleContextNotification mn = notification;
                    if (108 == mn.getAction()) {
                        JmxRegistrationContext.this.resolvedDomain = null;
                        contexts.set(null);
                    }
                }
            });
        }
        catch (NotificationException e) {
            this.logger.warn("Did not cleanup properly.", (Throwable)e);
        }
    }

    public static JmxRegistrationContext getCurrent(MuleContext context) {
        JmxRegistrationContext ctx = contexts.get();
        if (ctx == null) {
            ctx = new JmxRegistrationContext(context);
        }
        contexts.set(ctx);
        return ctx;
    }

    public String getResolvedDomain() {
        return this.resolvedDomain;
    }

    public void setResolvedDomain(String resolvedDomain) {
        this.resolvedDomain = resolvedDomain;
    }
}

