/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.agent.Agent;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.management.i18n.ManagementMessages;
import org.mule.runtime.module.management.mbean.YourKitProfilerService;
import org.mule.runtime.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.runtime.module.management.support.JmxSupport;
import org.mule.runtime.module.management.support.JmxSupportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YourKitProfilerAgent
implements Agent,
MuleContextAware {
    public static final String PROFILER_OBJECT_NAME = "name=Profiler";
    private String name = "yourkit-profiler";
    private MBeanServer mBeanServer;
    private ObjectName profilerName;
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    protected static final Logger logger = LoggerFactory.getLogger(YourKitProfilerAgent.class);
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Profiler JMX Agent";
    }

    public List<Class<? extends Agent>> getDependentAgents() {
        return Collections.emptyList();
    }

    public void initialise() throws InitialisationException {
        if (!this.isApiAvailable()) {
            logger.warn("Cannot find YourKit API. Profiler JMX Agent will be unregistered.");
            this.unregisterMeQuietly();
            return;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.isEmpty()) {
            throw new InitialisationException(ManagementMessages.noMBeanServerAvailable(), (Initialisable)this);
        }
        try {
            this.mBeanServer = (MBeanServer)servers.get(0);
            this.profilerName = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":" + PROFILER_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(new YourKitProfilerService(), this.profilerName);
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToStart((String)this.getName()), (Throwable)e, (Initialisable)this);
        }
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer == null || this.profilerName == null) {
            return;
        }
        if (this.mBeanServer.isRegistered(this.profilerName)) {
            this.mBeanServer.unregisterMBean(this.profilerName);
        }
    }

    protected void unregisterMeQuietly() {
        try {
            this.muleContext.getRegistry().unregisterAgent(this.getName());
        }
        catch (MuleException muleException) {
            // empty catch block
        }
    }

    private boolean isApiAvailable() {
        try {
            ClassUtils.getClass((String)"com.yourkit.api.Controller");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
        try {
            this.unregisterMBeansIfNecessary();
        }
        catch (Exception e) {
            logger.error("Couldn't unregister MBean: " + (this.profilerName != null ? this.profilerName.getCanonicalName() : "null"), (Throwable)e);
        }
    }
}

