/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.management.agent;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.AbstractAgent;
import org.mule.runtime.core.api.agent.Agent;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.construct.AbstractFlowConstruct;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.NotificationException;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.management.agent.ClassloaderSwitchingMBeanWrapper;
import org.mule.runtime.module.management.agent.ConfigurableJMXAuthenticator;
import org.mule.runtime.module.management.agent.JmxManagementException;
import org.mule.runtime.module.management.agent.WrapperManagerAgent;
import org.mule.runtime.module.management.i18n.ManagementMessages;
import org.mule.runtime.module.management.mbean.ApplicationService;
import org.mule.runtime.module.management.mbean.FlowConstructService;
import org.mule.runtime.module.management.mbean.FlowConstructServiceMBean;
import org.mule.runtime.module.management.mbean.MuleConfigurationService;
import org.mule.runtime.module.management.mbean.MuleConfigurationServiceMBean;
import org.mule.runtime.module.management.mbean.MuleService;
import org.mule.runtime.module.management.mbean.MuleServiceMBean;
import org.mule.runtime.module.management.mbean.StatisticsService;
import org.mule.runtime.module.management.mbean.StatisticsServiceMBean;
import org.mule.runtime.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.runtime.module.management.support.JmxSupport;
import org.mule.runtime.module.management.support.JmxSupportFactory;
import org.mule.runtime.module.management.support.SimplePasswordJmxAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJmxAgent
extends AbstractAgent {
    public static final String NAME = "jmx-agent";
    public static final String DEFAULT_REMOTING_URI = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
    public static final Map<String, String> DEFAULT_CONNECTOR_SERVER_PROPERTIES;
    public static final String DEFAULT_JMX_AUTHENTICATOR;
    protected static final Logger logger;
    protected boolean locateServer = true;
    protected boolean containerMode = true;
    private boolean createServer = false;
    private String connectorServerUrl;
    private MBeanServer mBeanServer;
    private JMXConnectorServer connectorServer;
    private Map<String, Object> connectorServerProperties = null;
    private boolean enableStatistics = true;
    private final AtomicBoolean serverCreated = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    protected JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    private ConfigurableJMXAuthenticator jmxAuthenticator;
    private Registry rmiRegistry;
    private boolean createRmiRegistry = true;
    private Map<String, String> credentials = new HashMap<String, String>();
    private MuleContextStartedListener muleContextStartedListener;
    private MuleContextStoppedListener muleContextStoppedListener;

    public AbstractJmxAgent() {
        super(NAME);
        this.connectorServerProperties = new HashMap<String, String>(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
    }

    public String getDescription() {
        if (this.connectorServerUrl != null) {
            return this.name + ": " + this.connectorServerUrl;
        }
        return "JMX Agent";
    }

    public void initialise() throws InitialisationException {
        if (this.initialized.get()) {
            return;
        }
        this.containerMode = this.muleContext.getConfiguration().isContainerMode();
        try {
            Object agent = this.muleContext.getRegistry().lookupObject(((Object)((Object)this)).getClass());
            if (agent == this && this.initialized.get()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found an existing JMX agent in the registry, we're done here.");
                }
                return;
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (this.mBeanServer == null && this.createServer) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
            this.serverCreated.set(true);
        }
        if (this.mBeanServer == null && this.locateServer) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer == null) {
            throw new InitialisationException(ManagementMessages.cannotLocateOrCreateServer(), (Initialisable)this);
        }
        if (StringUtils.isBlank((String)this.muleContext.getConfiguration().getId())) {
            throw new IllegalArgumentException("Manager ID is mandatory when running with JmxAgent. Give your Mule configuration a valid ID.");
        }
        try {
            this.muleContextStartedListener = new MuleContextStartedListener();
            this.muleContext.registerListener((ServerNotificationListener)this.muleContextStartedListener);
            this.muleContextStoppedListener = new MuleContextStoppedListener();
            this.muleContext.registerListener((ServerNotificationListener)this.muleContextStoppedListener);
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.initialized.compareAndSet(false, true);
    }

    protected void initRMI() throws Exception {
        String connectUri;
        String string = connectUri = this.connectorServerUrl != null ? this.connectorServerUrl : "";
        if (connectUri.contains("jmx:rmi")) {
            int i = connectUri.lastIndexOf("rmi://");
            URI uri = new URI(connectUri.substring(i));
            if (this.rmiRegistry == null) {
                try {
                    if (this.isCreateRmiRegistry()) {
                        try {
                            this.rmiRegistry = LocateRegistry.createRegistry(uri.getPort());
                        }
                        catch (ExportException e) {
                            logger.info("Registry on " + uri + " already bound. Attempting to use that instead");
                            this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                        }
                    } else {
                        this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                    }
                }
                catch (RemoteException e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
            }
        }
    }

    public void start() throws MuleException {
        try {
            this.initRMI();
            if (this.connectorServerUrl == null) {
                return;
            }
            logger.info("Creating and starting JMX agent connector Server");
            JMXServiceURL url = new JMXServiceURL(this.connectorServerUrl);
            if (this.connectorServerProperties == null) {
                this.connectorServerProperties = new HashMap<String, String>(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
            }
            if (!this.credentials.isEmpty()) {
                this.connectorServerProperties.put("jmx.remote.authenticator", this.getJmxAuthenticator());
            }
            this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.connectorServerProperties, this.mBeanServer);
            this.connectorServer.start();
        }
        catch (ExportException e) {
            throw new JmxManagementException(CoreMessages.failedToStart((String)"Jmx Agent"), e);
        }
        catch (Exception e) {
            throw new JmxManagementException(CoreMessages.failedToStart((String)"Jmx Agent"), e);
        }
    }

    public void stop() throws MuleException {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (Exception e) {
                throw new JmxManagementException(CoreMessages.failedToStop((String)"Jmx Connector"), e);
            }
        }
    }

    public void dispose() {
        this.unregisterMBeansIfNecessary();
        this.unregisterListeners();
        if (this.serverCreated.get()) {
            MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
        }
        this.mBeanServer = null;
        this.serverCreated.compareAndSet(true, false);
        this.initialized.set(false);
    }

    private void unregisterListeners() {
        this.muleContext.unregisterListener((ServerNotificationListener)this.muleContextStartedListener);
        this.muleContext.unregisterListener((ServerNotificationListener)this.muleContextStoppedListener);
    }

    protected void registerWrapperService() throws MuleException {
        WrapperManagerAgent wmAgent = new WrapperManagerAgent();
        if (this.muleContext.getRegistry().lookupAgent(wmAgent.getName()) == null) {
            this.muleContext.getRegistry().registerAgent((Agent)wmAgent);
        }
    }

    protected void registerStatisticsService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(String.format("%s:%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "type=Statistics,name=AllStatistics"));
        StatisticsService service = new StatisticsService();
        service.setMuleContext(this.muleContext);
        service.setEnabled(this.isEnableStatistics());
        ClassloaderSwitchingMBeanWrapper mBean = new ClassloaderSwitchingMBeanWrapper(service, StatisticsServiceMBean.class, this.muleContext.getExecutionClassLoader());
        logger.debug("Registering statistics with name: " + on);
        this.mBeanServer.registerMBean(mBean, on);
    }

    protected void registerMuleService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(String.format("%s:%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "name=MuleContext"));
        if (this.muleContext.getConfiguration().isContainerMode() && this.mBeanServer.isRegistered(on)) {
            return;
        }
        MuleService service = new MuleService(this.muleContext);
        ClassloaderSwitchingMBeanWrapper serviceMBean = new ClassloaderSwitchingMBeanWrapper(service, MuleServiceMBean.class, this.muleContext.getExecutionClassLoader());
        logger.debug("Registering mule with name: " + on);
        this.mBeanServer.registerMBean(serviceMBean, on);
    }

    protected void registerConfigurationService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(String.format("%s:%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "name=Configuration"));
        MuleConfigurationService service = new MuleConfigurationService(this.muleContext.getConfiguration());
        ClassloaderSwitchingMBeanWrapper mBean = new ClassloaderSwitchingMBeanWrapper(service, MuleConfigurationServiceMBean.class, this.muleContext.getExecutionClassLoader());
        logger.debug("Registering configuration with name: " + on);
        this.mBeanServer.registerMBean(mBean, on);
    }

    protected void registerFlowConstructServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        for (AbstractFlowConstruct flowConstruct : this.muleContext.getRegistry().lookupObjects(AbstractFlowConstruct.class)) {
            String rawName = flowConstruct.getName();
            String name = this.jmxSupport.escape(rawName);
            String jmxName = String.format("%s:type=%s,name=%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), flowConstruct.getConstructType(), name);
            ObjectName on = this.jmxSupport.getObjectName(jmxName);
            FlowConstructService fcMBean = new FlowConstructService(flowConstruct.getConstructType(), rawName, this.muleContext, flowConstruct.getStatistics());
            ClassloaderSwitchingMBeanWrapper wrapper = new ClassloaderSwitchingMBeanWrapper(fcMBean, FlowConstructServiceMBean.class, this.muleContext.getExecutionClassLoader());
            logger.debug("Registering service with name: " + on);
            this.mBeanServer.registerMBean(wrapper, on);
        }
    }

    protected void registerApplicationServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        FlowConstructStatistics appStats = this.muleContext.getStatistics().getApplicationStatistics();
        if (appStats != null) {
            String rawName = appStats.getName();
            String name = this.jmxSupport.escape(rawName);
            String jmxName = String.format("%s:type=%s,name=%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), appStats.getFlowConstructType(), name);
            ObjectName on = this.jmxSupport.getObjectName(jmxName);
            ApplicationService fcMBean = new ApplicationService(appStats.getFlowConstructType(), rawName, this.muleContext, appStats);
            ClassloaderSwitchingMBeanWrapper wrapper = new ClassloaderSwitchingMBeanWrapper(fcMBean, FlowConstructServiceMBean.class, this.muleContext.getExecutionClassLoader());
            logger.debug("Registering application statistics with name: " + on);
            this.mBeanServer.registerMBean(wrapper, on);
        }
    }

    public boolean isCreateServer() {
        return this.createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.createServer = createServer;
    }

    public boolean isLocateServer() {
        return this.locateServer;
    }

    public void setLocateServer(boolean locateServer) {
        this.locateServer = locateServer;
    }

    public String getConnectorServerUrl() {
        return this.connectorServerUrl;
    }

    public void setConnectorServerUrl(String connectorServerUrl) {
        this.connectorServerUrl = connectorServerUrl;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public Map<String, Object> getConnectorServerProperties() {
        return this.connectorServerProperties;
    }

    public void setConnectorServerProperties(Map<String, Object> connectorServerProperties) {
        this.connectorServerProperties = connectorServerProperties;
    }

    public JmxSupportFactory getJmxSupportFactory() {
        return this.jmxSupportFactory;
    }

    public void setJmxSupportFactory(JmxSupportFactory jmxSupportFactory) {
        this.jmxSupportFactory = jmxSupportFactory;
    }

    public void setCredentials(Map<String, String> newCredentials) {
        this.credentials.clear();
        if (newCredentials != null && !newCredentials.isEmpty()) {
            this.credentials.putAll(newCredentials);
        }
    }

    protected void unregisterMBeansIfNecessary() {
        this.unregisterMBeansIfNecessary(false);
    }

    protected void unregisterMBeansIfNecessary(boolean containerMode) {
        if (this.mBeanServer == null) {
            return;
        }
        try {
            String domain = this.jmxSupport.getDomainName(this.muleContext, false);
            ObjectName query = this.jmxSupport.getObjectName(domain + ":*");
            Set<ObjectName> mbeans = this.mBeanServer.queryNames(query, null);
            while (!mbeans.isEmpty()) {
                ObjectName name = mbeans.iterator().next();
                try {
                    if (!containerMode || !"name=MuleContext".equals(name.getCanonicalKeyPropertyListString())) {
                        this.mBeanServer.unregisterMBean(name);
                    }
                }
                catch (Exception e) {
                    logger.warn(String.format("Failed to unregister MBean: %s. Error is: %s", name, e.getMessage()));
                }
                mbeans = this.mBeanServer.queryNames(query, null);
                if (!containerMode) continue;
                mbeans.remove(this.jmxSupport.getObjectName(String.format("%s:%s", domain, "name=MuleContext")));
            }
        }
        catch (MalformedObjectNameException e) {
            logger.warn("Failed to create ObjectName query", (Throwable)e);
        }
    }

    public Registry getRmiRegistry() {
        return this.rmiRegistry;
    }

    public void setRmiRegistry(Registry rmiRegistry) {
        this.rmiRegistry = rmiRegistry;
    }

    public boolean isCreateRmiRegistry() {
        return this.createRmiRegistry;
    }

    public void setCreateRmiRegistry(boolean createRmiRegistry) {
        this.createRmiRegistry = createRmiRegistry;
    }

    protected abstract void registerServices() throws MuleException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException;

    public ConfigurableJMXAuthenticator getJmxAuthenticator() {
        if (this.jmxAuthenticator == null) {
            this.jmxAuthenticator = new SimplePasswordJmxAuthenticator();
            this.jmxAuthenticator.configure(this.credentials);
        }
        return this.jmxAuthenticator;
    }

    public void setJmxAuthenticator(ConfigurableJMXAuthenticator jmxAuthenticator) {
        this.jmxAuthenticator = jmxAuthenticator;
    }

    static {
        DEFAULT_JMX_AUTHENTICATOR = SimplePasswordJmxAuthenticator.class.getName();
        logger = LoggerFactory.getLogger(AbstractJmxAgent.class);
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("jmx.remote.jndi.rebind", "true");
        DEFAULT_CONNECTOR_SERVER_PROPERTIES = Collections.unmodifiableMap(props);
    }

    protected class MuleContextStoppedListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        protected MuleContextStoppedListener() {
        }

        public void onNotification(MuleContextNotification notification) {
            if (notification.getAction() == 106) {
                boolean containerMode = notification.getMuleContext().getConfiguration().isContainerMode();
                AbstractJmxAgent.this.unregisterMBeansIfNecessary(containerMode);
            }
        }
    }

    protected class MuleContextStartedListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        protected MuleContextStartedListener() {
        }

        public void onNotification(MuleContextNotification notification) {
            if (notification.getAction() == 104) {
                try {
                    AbstractJmxAgent.this.registerServices();
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.objectFailedToInitialise((String)"MBeans"), (Throwable)e);
                }
            }
        }
    }
}

