/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.agent.Agent;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.module.management.agent.JmxManagementException;
import org.mule.module.management.agent.RmiRegistryAgent;
import org.mule.module.management.agent.WrapperManagerAgent;
import org.mule.module.management.i18n.ManagementMessages;
import org.mule.module.management.mbean.ConnectorService;
import org.mule.module.management.mbean.EndpointService;
import org.mule.module.management.mbean.ModelService;
import org.mule.module.management.mbean.MuleConfigurationService;
import org.mule.module.management.mbean.MuleService;
import org.mule.module.management.mbean.ServiceService;
import org.mule.module.management.mbean.StatisticsService;
import org.mule.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;
import org.mule.module.management.support.SimplePasswordJmxAuthenticator;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class JmxAgent
extends AbstractAgent {
    public static final String DEFAULT_REMOTING_URI = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
    public static final Map DEFAULT_CONNECTOR_SERVER_PROPERTIES;
    public static final String DEFAULT_JMX_AUTHENTICATOR;
    protected static final Log logger;
    protected boolean locateServer = true;
    private boolean createServer = true;
    private String connectorServerUrl;
    private MBeanServer mBeanServer;
    private JMXConnectorServer connectorServer;
    private Map connectorServerProperties = null;
    private boolean enableStatistics = true;
    private final AtomicBoolean serverCreated = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    private Map credentials = new HashMap();

    public JmxAgent() {
        super("jmx-agent");
        this.connectorServerProperties = new HashMap(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
    }

    public String getDescription() {
        if (this.connectorServerUrl != null) {
            return this.name + ": " + this.connectorServerUrl;
        }
        return "JMX Agent";
    }

    public List getDependentAgents() {
        return Arrays.asList(RmiRegistryAgent.class);
    }

    public void initialise() throws InitialisationException {
        ArrayList<MBeanServer> l;
        if (this.initialized.get()) {
            return;
        }
        if (this.mBeanServer == null && !this.locateServer && !this.createServer) {
            throw new InitialisationException(ManagementMessages.createOrLocateShouldBeSet(), (Initialisable)this);
        }
        if (this.mBeanServer == null && this.locateServer && (l = MBeanServerFactory.findMBeanServer(null)) != null && l.size() > 0) {
            this.mBeanServer = (MBeanServer)l.get(0);
        }
        if (this.mBeanServer == null && this.createServer) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
            this.serverCreated.set(true);
        }
        if (this.mBeanServer == null) {
            throw new InitialisationException(ManagementMessages.cannotLocateOrCreateServer(), (Initialisable)this);
        }
        if (StringUtils.isBlank((String)this.muleContext.getConfiguration().getId())) {
            throw new IllegalArgumentException("Manager ID is mandatory when running with JmxAgent. Give your Mule configuration a valid ID.");
        }
        try {
            this.muleContext.registerListener((ServerNotificationListener)new MuleContextStartedListener());
            this.muleContext.registerListener((ServerNotificationListener)new MuleContextStoppedListener());
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.initialized.compareAndSet(false, true);
    }

    public void start() throws MuleException {
        try {
            logger.info((Object)"Creating and starting JMX agent connector Server");
            if (this.connectorServerUrl != null) {
                JMXServiceURL url = new JMXServiceURL(this.connectorServerUrl);
                if (this.connectorServerProperties == null) {
                    this.connectorServerProperties = new HashMap(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
                }
                if (!this.credentials.isEmpty()) {
                    JMXAuthenticator jmxAuthenticator = (JMXAuthenticator)ClassUtils.instanciateClass((String)DEFAULT_JMX_AUTHENTICATOR, (Object[])new Object[0]);
                    ((SimplePasswordJmxAuthenticator)jmxAuthenticator).setCredentials(this.credentials);
                    this.connectorServerProperties.put("jmx.remote.authenticator", jmxAuthenticator);
                }
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.connectorServerProperties, this.mBeanServer);
                this.connectorServer.start();
            }
        }
        catch (ExportException e) {
            throw new JmxManagementException(CoreMessages.failedToStart((String)"Jmx Agent"), e);
        }
        catch (Exception e) {
            throw new JmxManagementException(CoreMessages.failedToStart((String)"Jmx Agent"), e);
        }
    }

    public void stop() throws MuleException {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (Exception e) {
                throw new JmxManagementException(CoreMessages.failedToStop((String)"Jmx Connector"), e);
            }
        }
    }

    public void dispose() {
        this.unregisterMBeansIfNecessary();
        if (this.serverCreated.get()) {
            MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
        }
        this.mBeanServer = null;
        this.serverCreated.compareAndSet(true, false);
        this.initialized.set(false);
    }

    public void registered() {
    }

    public void unregistered() {
    }

    protected void registerWrapperService() throws MuleException {
        WrapperManagerAgent wmAgent = new WrapperManagerAgent();
        if (this.muleContext.getRegistry().lookupAgent(wmAgent.getName()) == null) {
            this.muleContext.getRegistry().registerAgent((Agent)wmAgent);
        }
    }

    protected void registerStatisticsService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.Statistics,name=AllStatistics");
        StatisticsService mBean = new StatisticsService();
        mBean.setMuleContext(this.muleContext);
        mBean.setEnabled(this.isEnableStatistics());
        logger.debug((Object)("Registering statistics with name: " + on));
        this.mBeanServer.registerMBean(mBean, on);
    }

    protected void registerModelServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        for (Model model : this.muleContext.getRegistry().lookupObjects(Model.class)) {
            ModelService serviceMBean = new ModelService(model);
            String rawName = serviceMBean.getName() + "(" + serviceMBean.getType() + ")";
            String name = this.jmxSupport.escape(rawName);
            ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.Model,name=" + name);
            logger.debug((Object)("Registering model with name: " + on));
            this.mBeanServer.registerMBean(serviceMBean, on);
        }
    }

    protected void registerMuleService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.MuleContext,name=MuleServerInfo");
        MuleService serviceMBean = new MuleService(this.muleContext);
        logger.debug((Object)("Registering mule with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
    }

    protected void registerConfigurationService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.Configuration,name=GlobalConfiguration");
        MuleConfigurationService serviceMBean = new MuleConfigurationService(this.muleContext.getConfiguration());
        logger.debug((Object)("Registering configuration with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
    }

    protected void registerServiceServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        Iterator iterator = this.muleContext.getRegistry().lookupObjects(Service.class).iterator();
        while (iterator.hasNext()) {
            String rawName = ((Service)iterator.next()).getName();
            String name = this.jmxSupport.escape(rawName);
            ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.Service,name=" + name);
            ServiceService serviceMBean = new ServiceService(rawName, this.muleContext);
            logger.debug((Object)("Registering service with name: " + on));
            this.mBeanServer.registerMBean(serviceMBean, on);
        }
    }

    protected void registerEndpointServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        for (Connector connector : this.muleContext.getRegistry().lookupObjects(Connector.class)) {
            if (connector instanceof AbstractConnector) {
                Iterator iterator = ((AbstractConnector)connector).getReceivers().values().iterator();
                while (iterator.hasNext()) {
                    EndpointService mBean = new EndpointService((MessageReceiver)iterator.next());
                    String rawName = mBean.getName();
                    String name = this.jmxSupport.escape(rawName);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Attempting to register service with name: " + this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.Endpoint,service=" + this.jmxSupport.escape(mBean.getComponentName()) + ",name=" + name));
                    }
                    ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.Endpoint,service=" + this.jmxSupport.escape(mBean.getComponentName()) + ",name=" + name);
                    this.mBeanServer.registerMBean(mBean, on);
                    logger.info((Object)("Registered Endpoint Service with name: " + on));
                }
                continue;
            }
            logger.warn((Object)("Connector: " + connector + " is not an istance of AbstractConnector, cannot obtain Endpoint MBeans from it"));
        }
    }

    protected void registerConnectorServices() throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        for (Connector connector : this.muleContext.getRegistry().lookupObjects(Connector.class)) {
            ConnectorService mBean = new ConnectorService(connector);
            String rawName = mBean.getName();
            String name = this.jmxSupport.escape(rawName);
            String stringName = this.jmxSupport.getDomainName(this.muleContext) + ":type=org.mule.Connector,name=" + name;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to register service with name: " + stringName));
            }
            ObjectName oName = this.jmxSupport.getObjectName(stringName);
            this.mBeanServer.registerMBean(mBean, oName);
            logger.info((Object)("Registered Connector Service with name " + oName));
        }
    }

    public boolean isCreateServer() {
        return this.createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.createServer = createServer;
    }

    public boolean isLocateServer() {
        return this.locateServer;
    }

    public void setLocateServer(boolean locateServer) {
        this.locateServer = locateServer;
    }

    public String getConnectorServerUrl() {
        return this.connectorServerUrl;
    }

    public void setConnectorServerUrl(String connectorServerUrl) {
        this.connectorServerUrl = connectorServerUrl;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public Map getConnectorServerProperties() {
        return this.connectorServerProperties;
    }

    public void setConnectorServerProperties(Map connectorServerProperties) {
        this.connectorServerProperties = connectorServerProperties;
    }

    public JmxSupportFactory getJmxSupportFactory() {
        return this.jmxSupportFactory;
    }

    public void setJmxSupportFactory(JmxSupportFactory jmxSupportFactory) {
        this.jmxSupportFactory = jmxSupportFactory;
    }

    public void setCredentials(Map newCredentials) {
        this.credentials.clear();
        if (newCredentials != null && !newCredentials.isEmpty()) {
            this.credentials.putAll(newCredentials);
        }
    }

    protected void unregisterMBeansIfNecessary() {
        if (this.mBeanServer == null) {
            return;
        }
        try {
            ObjectName query = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":*");
            Set<ObjectName> mbeans = this.mBeanServer.queryNames(query, null);
            while (!mbeans.isEmpty()) {
                ObjectName name = mbeans.iterator().next();
                try {
                    this.mBeanServer.unregisterMBean(name);
                }
                catch (Exception e) {
                    logger.warn((Object)String.format("Failed to unregister MBean: %s. Error is: %s", name, e.getMessage()));
                }
                mbeans = this.mBeanServer.queryNames(query, null);
            }
        }
        catch (MalformedObjectNameException e) {
            logger.warn((Object)"Failed to create ObjectName query", (Throwable)e);
        }
    }

    static {
        DEFAULT_JMX_AUTHENTICATOR = SimplePasswordJmxAuthenticator.class.getName();
        logger = LogFactory.getLog(JmxAgent.class);
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("jmx.remote.jndi.rebind", "true");
        DEFAULT_CONNECTOR_SERVER_PROPERTIES = Collections.unmodifiableMap(props);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MuleContextStoppedListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        protected MuleContextStoppedListener() {
        }

        public void onNotification(MuleContextNotification notification) {
            if (notification.getAction() == 106) {
                JmxAgent.this.unregisterMBeansIfNecessary();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MuleContextStartedListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        protected MuleContextStartedListener() {
        }

        public void onNotification(MuleContextNotification notification) {
            if (notification.getAction() == 104) {
                try {
                    JmxAgent.this.registerWrapperService();
                    JmxAgent.this.registerStatisticsService();
                    JmxAgent.this.registerMuleService();
                    JmxAgent.this.registerConfigurationService();
                    JmxAgent.this.registerModelServices();
                    JmxAgent.this.registerServiceServices();
                    JmxAgent.this.registerEndpointServices();
                    JmxAgent.this.registerConnectorServices();
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.objectFailedToInitialise((String)"MBeans"), (Throwable)e);
                }
            }
        }
    }
}

