/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ManagerNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ManagerNotification;
import org.mule.context.notification.NotificationException;

public class JmxRegistrationContext {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    private static final ThreadLocal contexts = new ThreadLocal();
    private String resolvedDomain;

    private JmxRegistrationContext(MuleContext context) {
        try {
            context.registerListener((ServerNotificationListener)new ManagerNotificationListener(){

                public void onNotification(ServerNotification notification) {
                    ManagerNotification mn = (ManagerNotification)notification;
                    if (108 == mn.getAction()) {
                        JmxRegistrationContext.this.resolvedDomain = null;
                        contexts.set(null);
                    }
                }
            });
        }
        catch (NotificationException e) {
            this.logger.warn((Object)"Did not cleanup properly.", (Throwable)e);
        }
    }

    public static JmxRegistrationContext getCurrent(MuleContext context) {
        JmxRegistrationContext ctx = (JmxRegistrationContext)contexts.get();
        if (ctx == null) {
            ctx = new JmxRegistrationContext(context);
        }
        contexts.set(ctx);
        return ctx;
    }

    public String getResolvedDomain() {
        return this.resolvedDomain;
    }

    public void setResolvedDomain(String resolvedDomain) {
        this.resolvedDomain = resolvedDomain;
    }
}

