/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.mbeans.EndpointServiceMBean;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ObjectNameHelper;

public class EndpointService
implements EndpointServiceMBean {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private UMOImmutableEndpoint endpoint;
    private UMOMessageReceiver receiver;
    private String name;
    private String componentName;

    public EndpointService(UMOImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.init();
    }

    public EndpointService(UMOMessageReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"Receiver").getMessage());
        }
        this.endpoint = receiver.getEndpoint();
        this.receiver = receiver;
        this.componentName = receiver.getComponent().getName();
        this.init();
    }

    private void init() {
        if (this.endpoint == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"Endpoint").getMessage());
        }
        if (this.receiver == null && !"receiver".equals(this.endpoint.getType())) {
            throw new IllegalArgumentException("Recevier is null for Endpoint MBean but the endpoint itself is a receiving endpoint");
        }
        this.name = ObjectNameHelper.getEndpointName((UMOImmutableEndpoint)this.endpoint);
    }

    public String getAddress() {
        return this.endpoint.getEndpointURI().getAddress();
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.receiver == null || this.receiver.isConnected();
    }

    public void connect() throws Exception {
        if (this.receiver != null && !this.receiver.isConnected()) {
            this.receiver.connect();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Endpoint is already connected");
        }
    }

    public void disconnect() throws Exception {
        if (this.receiver != null && this.receiver.isConnected()) {
            this.receiver.disconnect();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Endpoint is already disconnected");
        }
    }

    public boolean isSynchronous() {
        return this.endpoint.isSynchronous();
    }

    public String getType() {
        return this.endpoint.getType();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }
}

