/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.mule.MuleManager;
import org.mule.management.support.JmxRegistrationContext;
import org.mule.management.support.JmxSupport;
import org.mule.util.StringUtils;

public abstract class AbstractJmxSupport
implements JmxSupport {
    protected String resolveDomainClash(String domain) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.isEmpty()) {
            throw new IllegalStateException("MBeanServer is not available.");
        }
        MBeanServer server = (MBeanServer)servers.get(0);
        List<String> registeredDomains = Arrays.asList(server.getDomains());
        int counter = 1;
        if (registeredDomains.contains(domain)) {
            domain = domain + "." + counter;
        }
        while (registeredDomains.contains(domain)) {
            domain = domain.substring(0, domain.lastIndexOf(".") + 1) + ++counter;
        }
        return domain;
    }

    public String getDomainName() {
        JmxRegistrationContext ctx;
        String resolvedDomain;
        String domain = "Mule";
        String instanceId = StringUtils.defaultIfEmpty((String)MuleManager.getInstance().getId(), (String)"");
        if (instanceId.length() > 0) {
            domain = domain + "." + instanceId;
        }
        if (StringUtils.isBlank((String)(resolvedDomain = (ctx = JmxRegistrationContext.getCurrent()).getResolvedDomain()))) {
            domain = this.resolveDomainClash(domain);
            ctx.setResolvedDomain(domain);
        }
        return domain;
    }
}

