/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.query;

import java.util.List;
import org.mule.common.query.DefaultQueryVisitor;
import org.mule.common.query.Field;
import org.mule.common.query.expression.OperatorVisitor;
import org.mule.common.query.expression.Value;
import org.mule.module.magento.query.MagentoOperatorVisitor;

public class MagentoQueryVisitor
extends DefaultQueryVisitor {
    private StringBuilder nativeQuery = new StringBuilder();

    public OperatorVisitor operatorVisitor() {
        return MagentoOperatorVisitor.INSTANCE;
    }

    public void visitComparison(String operator, Field field, Value value) {
        Object v = value.getValue();
        if (v instanceof String) {
            v = String.format("'%s'", (String)v);
        }
        this.append(String.format(operator, field.getName(), v));
    }

    public void visitOrderByFields(List<Field> orderByFields) {
        for (Field field : orderByFields) {
            this.append(String.format("order(%s)", field.getName()));
        }
    }

    public void visitLimit(int limit) {
        this.append(String.format("to(%d)", limit));
    }

    public void visitOffset(int offset) {
        this.append(String.format("from(%d)", offset));
    }

    public String toQuery() {
        return this.nativeQuery.toString();
    }

    private void append(String value) {
        if (this.nativeQuery.length() > 0) {
            this.nativeQuery.append(", ");
        }
        this.nativeQuery.append(value);
    }
}

