/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.util;

import com.magento.api.AssociativeEntity;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.LazyDynaMap;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.WrapDynaClass;
import org.apache.commons.lang.UnhandledException;
import org.mule.module.magento.api.util.MagentoClass;

public final class MagentoObject {
    private static BeanUtilsBean beanUtils;
    private static MapToBeanConverter beanConverter;
    private static MapToAssociativeArray associativeConverter;
    private static ListToBeanArrayConverter listConverter;

    private MagentoObject() {
    }

    public static <T> T fromMap(Class<T> clazz, Map<String, Object> map) {
        return (T)beanConverter.convert(clazz, map);
    }

    public static AssociativeEntity[] fromMap(Map<String, Object> map) {
        return associativeConverter.convert(null, map);
    }

    public static <T> T[] fromMap(Class<T> clazz, List<Map<String, Object>> list) {
        return (Object[])listConverter.convert(Array.newInstance(clazz, 0).getClass(), list);
    }

    public static void removeNullValues(Map<String, Object> map) {
        if (map != null) {
            Iterator<Map.Entry<String, Object>> i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Object> entry = i.next();
                if (entry.getValue() != null) continue;
                i.remove();
            }
        }
    }

    static {
        beanConverter = new MapToBeanConverter();
        associativeConverter = new MapToAssociativeArray();
        listConverter = new ListToBeanArrayConverter();
        beanUtils = new BeanUtilsBean(new ConvertUtilsBean(){

            public Converter lookup(Class type) {
                if (MagentoClass.isMagentoArrayClass(type)) {
                    if (type.getComponentType() == AssociativeEntity.class) {
                        return associativeConverter;
                    }
                    return listConverter;
                }
                if (MagentoClass.isMagentoClass(type)) {
                    return beanConverter;
                }
                return super.lookup(type);
            }
        }){

            protected Object convert(Object value, Class targetType) {
                if (!targetType.isPrimitive() && value == null) {
                    return null;
                }
                return super.convert(value, targetType);
            }
        };
    }

    private static class MapToBeanConverter
    implements Converter {
        private MapToBeanConverter() {
        }

        public Object convert(Class type, Object value) {
            try {
                LazyDynaMap dynaMap = new LazyDynaMap((Map)value);
                WrapDynaBean bean = (WrapDynaBean)WrapDynaClass.createDynaClass((Class)type).newInstance();
                beanUtils.copyProperties((Object)bean, (Object)dynaMap);
                beanUtils.copyProperty((Object)bean, "", value);
                return bean.getInstance();
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
        }
    }

    private static class MapToAssociativeArray
    implements Converter {
        private MapToAssociativeArray() {
        }

        public AssociativeEntity[] convert(Class type, Object value) {
            try {
                Map map = (Map)value;
                AssociativeEntity[] array = new AssociativeEntity[map.size()];
                int i = 0;
                for (Map.Entry entry : map.entrySet()) {
                    array[i++] = new AssociativeEntity((String)entry.getKey(), (String)entry.getValue());
                }
                return array;
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
        }
    }

    private static class ListToBeanArrayConverter
    implements Converter {
        private ListToBeanArrayConverter() {
        }

        public Object convert(Class type, Object value) {
            try {
                List list = (List)value;
                Object[] array = (Object[])Array.newInstance(type.getComponentType(), list.size());
                Iterator iter = list.iterator();
                for (int i = 0; i < array.length; ++i) {
                    array[i] = MagentoObject.fromMap(type.getComponentType(), (Map)iter.next());
                }
                return array;
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
        }
    }
}

