/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.util;

import com.magento.api.AssociativeEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.Validate;
import org.mule.module.magento.api.util.MagentoClass;

public class MagentoMap
extends BeanMap {
    private static final Transformer TO_MAP = new ToMapTransformer();

    public MagentoMap(Object bean) {
        super(bean);
    }

    public Object get(Object name) {
        Object value = super.get(name);
        if (value == null) {
            return null;
        }
        return this.transformValue(value, value.getClass());
    }

    private Object transformValue(Object value, Class<?> valueClazz) {
        if (MagentoClass.isMagentoArrayClass(valueClazz)) {
            if (valueClazz.getComponentType() == AssociativeEntity.class) {
                return MagentoMap.toMap((AssociativeEntity[])value);
            }
            return MagentoMap.toMap((Object[])value);
        }
        if (MagentoClass.isMagentoClass(valueClazz)) {
            return MagentoMap.toMap(value);
        }
        return value;
    }

    public String toString() {
        Iterator i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry e = (Map.Entry)i.next();
            String key = (String)e.getKey();
            Object value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    public static Map<String, Object> toMap(Object magentoObject) {
        Validate.isTrue((boolean)MagentoClass.isMagentoClass(magentoObject.getClass()));
        return new MagentoMap(magentoObject);
    }

    public static Map<String, Object> toMap(AssociativeEntity[] associativeEntities) {
        HashMap<String, Object> map = new HashMap<String, Object>(associativeEntities.length);
        for (AssociativeEntity association : associativeEntities) {
            map.put(association.getKey(), association.getValue());
        }
        return map;
    }

    public static List<Map<String, Object>> toMap(Object[] magentoObjects) {
        return (List)CollectionUtils.collect(Arrays.asList(magentoObjects), (Transformer)TO_MAP);
    }

    private static final class ToMapTransformer
    implements Transformer {
        private ToMapTransformer() {
        }

        public Object transform(Object input) {
            return MagentoMap.toMap(input);
        }
    }
}

