/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.magento.api.catalog.model;

import org.apache.commons.lang.Validate;
import org.mule.module.magento.api.catalog.model.ProductIdentifier;

public final class ProductIdentifiers {
    private ProductIdentifiers() {
    }

    public static ProductIdentifier from(String productSku, Integer productId, String idOrSku) {
        if (productSku != null) {
            ProductIdentifiers.validateNull(idOrSku, productId);
            return new ProductIdentifier.Sku(productSku);
        }
        if (productId != null) {
            ProductIdentifiers.validateNull(idOrSku, productSku);
            return new ProductIdentifier.Id(productId);
        }
        Validate.notNull((Object)idOrSku, (String)"No product identifier was specifier");
        return new ProductIdentifier.IdOrSku(idOrSku);
    }

    private static void validateNull(Object o1, Object o2) {
        Validate.isTrue((o1 == null && o2 == null ? 1 : 0) != 0, (String)"More than one product identifier specified");
    }
}

