/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.logging;

import org.mule.module.logging.MuleLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class DispatchingLogger
implements Logger {
    protected static final Integer NO_CCL_CLASSLOADER = 0;
    protected Logger originalLogger;
    protected Integer originalClassLoaderHash;
    private String name;
    private MuleLoggerFactory factory;

    public DispatchingLogger(Logger originalLogger, MuleLoggerFactory factory) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        this.originalClassLoaderHash = ccl == null ? NO_CCL_CLASSLOADER.intValue() : ccl.hashCode();
        this.originalLogger = originalLogger;
        this.name = originalLogger.getName();
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public void trace(String msg) {
        this.getLogger().trace(msg);
    }

    public void trace(String format, Object arg) {
        this.getLogger().trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.getLogger().trace(format, arg1, arg2);
    }

    public void trace(String format, Object[] argArray) {
        this.getLogger().trace(format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.getLogger().trace(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.getLogger().isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.getLogger().trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.getLogger().trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.getLogger().trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object[] argArray) {
        this.getLogger().trace(marker, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.getLogger().trace(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public void debug(String msg) {
        this.getLogger().debug(msg);
    }

    public void debug(String format, Object arg) {
        this.getLogger().debug(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.getLogger().debug(format, arg1, arg2);
    }

    public void debug(String format, Object[] argArray) {
        this.getLogger().debug(format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.getLogger().debug(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.getLogger().isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.getLogger().debug(marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.getLogger().debug(marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.getLogger().debug(marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        this.getLogger().debug(marker, format, argArray);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.getLogger().debug(marker, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public void info(String msg) {
        this.getLogger().info(msg);
    }

    public void info(String format, Object arg) {
        this.getLogger().info(format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.getLogger().info(format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.getLogger().info(format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.getLogger().info(msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.getLogger().isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.getLogger().info(marker, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.getLogger().info(marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.getLogger().info(marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object[] argArray) {
        this.getLogger().info(marker, format, argArray);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.getLogger().info(marker, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    public void warn(String msg) {
        this.getLogger().warn(msg);
    }

    public void warn(String format, Object arg) {
        this.getLogger().warn(format, arg);
    }

    public void warn(String format, Object[] argArray) {
        this.getLogger().warn(format, argArray);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.getLogger().warn(format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.getLogger().warn(msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.getLogger().isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.getLogger().warn(marker, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.getLogger().warn(marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.getLogger().warn(marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        this.getLogger().warn(marker, format, argArray);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.getLogger().warn(marker, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public void error(String msg) {
        this.getLogger().error(msg);
    }

    public void error(String format, Object arg) {
        this.getLogger().error(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.getLogger().error(format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.getLogger().error(format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.getLogger().error(msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.getLogger().isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.getLogger().error(marker, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.getLogger().error(marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.getLogger().error(marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object[] argArray) {
        this.getLogger().error(marker, format, argArray);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.getLogger().error(marker, msg, t);
    }

    protected Logger getLogger() {
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        if (currentCl == null || currentCl.hashCode() == this.originalClassLoaderHash.intValue()) {
            return this.originalLogger;
        }
        return this.factory.getLogger(this.getName(), currentCl);
    }

    public MuleLoggerFactory getFactory() {
        return this.factory;
    }
}

