/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.domain;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.DomainMuleContextAwareConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.MuleContextFactory;
import org.mule.api.context.notification.MuleContextListener;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.config.builders.AutoConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.DeploymentStopException;
import org.mule.module.launcher.MuleDeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.NullDeploymentListener;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.MuleContextDeploymentListener;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DomainDescriptor;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.launcher.domain.DomainClassLoaderRepository;
import org.mule.module.launcher.domain.DomainMuleContextBuilder;
import org.mule.module.launcher.domain.DomainStartedSplashScreen;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.SplashScreen;

public class DefaultMuleDomain
implements Domain {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected final transient Log deployLogger = LogFactory.getLog(MuleDeploymentService.class);
    private final DomainClassLoaderRepository domainClassLoaderRepository;
    private final DomainDescriptor descriptor;
    private MuleContext muleContext;
    private DeploymentListener deploymentListener;
    private ArtifactClassLoader deploymentClassLoader;
    private Properties deploymentProperties;
    private File configResourceFile;

    public DefaultMuleDomain(DomainClassLoaderRepository domainClassLoaderRepository, DomainDescriptor descriptor) {
        this.domainClassLoaderRepository = domainClassLoaderRepository;
        this.deploymentListener = new NullDeploymentListener();
        this.descriptor = descriptor;
        this.refreshClassLoaderAndLoadConfigResourceFile();
    }

    private void refreshClassLoaderAndLoadConfigResourceFile() {
        this.deploymentClassLoader = this.domainClassLoaderRepository.getDomainClassLoader(this.descriptor);
        URL resource = this.deploymentClassLoader.findLocalResource("mule-domain-config.xml");
        if (resource != null) {
            try {
                this.configResourceFile = new File(URLDecoder.decode(resource.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to find config resource file: " + resource.getFile());
            }
        }
    }

    public void setDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public ConfigurationBuilder createApplicationConfigurationBuilder(Application application) throws Exception {
        String configBuilderClassName = this.determineConfigBuilderClassNameForApplication(application);
        ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)ClassUtils.instanciateClass((String)configBuilderClassName, (Object[])new Object[]{((ApplicationDescriptor)application.getDescriptor()).getAbsoluteResourcePaths()}, (ClassLoader)application.getArtifactClassLoader().getClassLoader());
        if (!this.containsSharedResources()) {
            return configurationBuilder;
        }
        if (!(configurationBuilder instanceof DomainMuleContextAwareConfigurationBuilder)) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("ConfigurationBuilder %s does not support domain context", configurationBuilder.getClass().getCanonicalName())));
        }
        ((DomainMuleContextAwareConfigurationBuilder)configurationBuilder).setDomainContext(this.getMuleContext());
        return configurationBuilder;
    }

    protected String determineConfigBuilderClassNameForApplication(Application defaultMuleApplication) {
        String builderFromDesc = ((ApplicationDescriptor)defaultMuleApplication.getDescriptor()).getConfigurationBuilder();
        if ("spring".equalsIgnoreCase(builderFromDesc)) {
            return "org.mule.config.spring.SpringXmlConfigurationBuilder";
        }
        if (builderFromDesc == null) {
            return AutoConfigurationBuilder.class.getName();
        }
        return builderFromDesc;
    }

    @Override
    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("New domain '%s'", this.getArtifactName())));
        }
        this.refreshClassLoaderAndLoadConfigResourceFile();
    }

    @Override
    public void init() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Initializing domain '%s'", this.getArtifactName())));
        }
        try {
            if (this.configResourceFile != null) {
                this.validateConfigurationFileDoNotUsesCoreNamespace();
                ConfigurationBuilder cfgBuilder = this.createConfigurationBuilder();
                if (!cfgBuilder.isConfigured()) {
                    ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>(3);
                    builders.add(this.createConfigurationBuilderFromDeploymentProperties());
                    this.addAnnotationsConfigBuilderIfPresent(builders);
                    builders.add(cfgBuilder);
                    MuleContextFactory muleContextFactory = this.getMuleContextFactory();
                    if (this.deploymentListener != null) {
                        muleContextFactory.addListener((MuleContextListener)new MuleContextDeploymentListener(this.getArtifactName(), this.deploymentListener));
                    }
                    DomainMuleContextBuilder domainMuleContextBuilder = new DomainMuleContextBuilder(this.descriptor.getName());
                    domainMuleContextBuilder.setDeploymentProperties(this.deploymentProperties);
                    this.muleContext = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)domainMuleContextBuilder);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    private void validateConfigurationFileDoNotUsesCoreNamespace() throws FileNotFoundException {
        try (Scanner scanner = null;){
            scanner = new Scanner(this.configResourceFile);
            while (scanner.hasNextLine()) {
                String lineFromFile = scanner.nextLine();
                if (!lineFromFile.contains("<mule ")) continue;
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Domain configuration file can not be created using core namespace. Use mule-domain namespace instead."));
            }
        }
    }

    protected void addAnnotationsConfigBuilderIfPresent(List<ConfigurationBuilder> builders) throws Exception {
        if (ClassUtils.isClassOnPath((String)"org.mule.config.AnnotationsConfigurationBuilder", this.getClass())) {
            Object configBuilder = ClassUtils.instanciateClass((String)"org.mule.config.AnnotationsConfigurationBuilder", (Object[])ClassUtils.NO_ARGS, this.getClass());
            builders.add((ConfigurationBuilder)configBuilder);
        }
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        try {
            return (ConfigurationBuilder)ClassUtils.instanciateClass((String)"org.mule.config.spring.SpringXmlDomainConfigurationBuilder", (Object[])new Object[]{this.getResourceFiles()[0].getName()}, (ClassLoader)this.deploymentClassLoader.getClassLoader());
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public void start() {
        try {
            if (this.muleContext != null) {
                try {
                    this.muleContext.start();
                }
                catch (MuleException e) {
                    this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
                    throw new DeploymentStartException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
                }
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                DomainStartedSplashScreen splashScreen = new DomainStartedSplashScreen();
                splashScreen.createMessage(this.descriptor);
                this.deployLogger.info((Object)splashScreen.toString());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        catch (Exception e) {
            throw new DeploymentStartException(CoreMessages.createStaticMessage((String)("Failure trying to start domain " + this.getArtifactName())), e);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Stopping domain '%s'", this.getArtifactName())));
            }
            if (this.muleContext != null) {
                this.cancelStart();
                this.muleContext.stop();
            }
        }
        catch (Exception e) {
            throw new DeploymentStopException(CoreMessages.createStaticMessage((String)("Failure trying to stop domain " + this.getArtifactName())), e);
        }
    }

    @Override
    public void dispose() {
        ClassLoader originalClassloader;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Disposing domain '%s'", this.getArtifactName())));
        }
        if ((originalClassloader = Thread.currentThread().getContextClassLoader()) != this.deploymentClassLoader.getClassLoader()) {
            Thread.currentThread().setContextClassLoader(this.deploymentClassLoader.getClassLoader());
        }
        if (this.muleContext != null) {
            this.muleContext.dispose();
        }
        if (originalClassloader != this.deploymentClassLoader.getClassLoader()) {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
        this.deploymentClassLoader.dispose();
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getName();
    }

    @Override
    public DomainDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public File[] getResourceFiles() {
        File[] fileArray;
        if (this.configResourceFile == null) {
            fileArray = new File[]{};
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = this.configResourceFile;
        }
        return fileArray;
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.deploymentClassLoader;
    }

    public void initialise() {
        try {
            if (this.muleContext != null) {
                this.muleContext.initialise();
            }
        }
        catch (InitialisationException e) {
            throw new DeploymentInitException(CoreMessages.createStaticMessage((String)("Failure trying to initialise domain " + this.getArtifactName())), e);
        }
    }

    protected ConfigurationBuilder createConfigurationBuilderFromDeploymentProperties() throws IOException {
        return new SimpleConfigurationBuilder((Map)this.deploymentProperties);
    }

    @Override
    public boolean containsSharedResources() {
        return this.muleContext != null;
    }

    protected MuleContextFactory getMuleContextFactory() {
        return new DefaultMuleContextFactory();
    }

    @Override
    public void setDeploymentProperties(Properties deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    @Override
    public void cancelStart() {
        if (this.muleContext != null && this.muleContext.getRegistry() != null && !this.muleContext.getRegistry().lookupObjects(Connector.class).isEmpty()) {
            for (Connector connector : this.muleContext.getRegistry().lookupObjects(Connector.class)) {
                if (connector.getRetryPolicyTemplate() == null) continue;
                connector.getRetryPolicyTemplate().stopRetrying();
            }
        }
    }
}

