/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.ArchiveDeployer;
import org.mule.module.launcher.ArtifactArchiveInstaller;
import org.mule.module.launcher.ArtifactDeployer;
import org.mule.module.launcher.ArtifactDeploymentTemplate;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentPropertiesUtils;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationStatus;
import org.mule.module.launcher.application.NullDeploymentListener;
import org.mule.module.launcher.artifact.Artifact;
import org.mule.module.launcher.artifact.ArtifactFactory;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.launcher.util.ObservableList;
import org.mule.util.CollectionUtils;
import org.mule.util.SplashScreen;

public class DefaultArchiveDeployer<T extends Artifact>
implements ArchiveDeployer<T> {
    public static final String ARTIFACT_NAME_PROPERTY = "artifactName";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    private static final Log logger = LogFactory.getLog(DefaultArchiveDeployer.class);
    static final String START_ARTIFACT_ON_DEPLOYMENT_PROPERTY = "startArtifactOnDeployment";
    private final ArtifactDeployer<T> deployer;
    private final ArtifactArchiveInstaller artifactArchiveInstaller;
    private final Map<String, ZombieFile> artifactZombieMap = new HashMap<String, ZombieFile>();
    private final File artifactDir;
    private final ObservableList<T> artifacts;
    private final ArtifactDeploymentTemplate deploymentTemplate;
    private ArtifactFactory<T> artifactFactory;
    private DeploymentListener deploymentListener = new NullDeploymentListener();
    private final DeploymentService deploymentService;

    public DefaultArchiveDeployer(ArtifactDeployer deployer, ArtifactFactory artifactFactory, ObservableList<T> artifacts, ArtifactDeploymentTemplate deploymentTemplate, DeploymentService deploymentService) {
        this.deployer = deployer;
        this.artifactFactory = artifactFactory;
        this.artifacts = artifacts;
        this.deploymentTemplate = deploymentTemplate;
        this.artifactDir = artifactFactory.getArtifactDir();
        this.artifactArchiveInstaller = new ArtifactArchiveInstaller(this.artifactDir);
        this.deploymentService = deploymentService;
    }

    @Override
    public T deployPackagedArtifact(String zip, Optional<Properties> deploymentProperties) throws DeploymentException {
        try {
            String artifactName = StringUtils.removeEndIgnoreCase((String)zip, (String)ZIP_FILE_SUFFIX);
            File artifactZip = new File(this.artifactDir, zip);
            URL url = artifactZip.toURI().toURL();
            return this.deployPackagedArtifact(url, artifactName, deploymentProperties);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(CoreMessages.createStaticMessage((String)("Failed to deploy from zip: " + zip)), e);
        }
    }

    @Override
    public T deployExplodedArtifact(String artifactDir) throws DeploymentException {
        if (!this.isUpdatedZombieArtifact(artifactDir)) {
            return null;
        }
        Optional properties = Optional.absent();
        return this.deployExplodedApp(artifactDir, (Optional<Properties>)properties);
    }

    @Override
    public T deployExplodedArtifact(String artifactDir, Optional<Properties> properties) throws DeploymentException {
        if (!this.isUpdatedZombieArtifact(artifactDir)) {
            return null;
        }
        return this.deployExplodedApp(artifactDir, properties);
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        Collection deployedAppNames = CollectionUtils.collect(this.artifacts, (Transformer)new BeanToPropertyValueTransformer(ARTIFACT_NAME_PROPERTY));
        if (deployedAppNames.contains(artifactName) && !this.artifactZombieMap.containsKey(artifactName)) {
            return false;
        }
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        return zombieFile == null || zombieFile.updatedZombieApp();
    }

    @Override
    public void undeployArtifact(String artifactId) {
        if (this.isZombieArtifact(artifactId)) {
            return;
        }
        Artifact artifact = (Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactId));
        this.undeploy(artifact);
    }

    @Override
    public File getDeploymentDirectory() {
        return this.artifactFactory.getArtifactDir();
    }

    @Override
    public T deployPackagedArtifact(URL artifactAchivedUrl, Optional<Properties> deploymentProperties) throws DeploymentException {
        try {
            T artifact;
            String artifactName;
            try {
                artifactName = this.artifactArchiveInstaller.installArtifact(artifactAchivedUrl);
            }
            catch (Throwable t) {
                File artifactArchive = new File(artifactAchivedUrl.toURI());
                String artifactName2 = StringUtils.removeEndIgnoreCase((String)artifactArchive.getName(), (String)ZIP_FILE_SUFFIX);
                this.logDeploymentFailure(t, artifactName2);
                this.addZombieFile(artifactName2, artifactArchive);
                this.deploymentListener.onDeploymentFailure(artifactName2, t);
                throw t;
            }
            try {
                artifact = this.artifactFactory.createArtifact(artifactName, deploymentProperties);
                this.trackArtifact(artifact);
            }
            catch (Throwable t) {
                File artifactArchive = new File(artifactAchivedUrl.toURI());
                this.logDeploymentFailure(t, artifactName);
                this.addZombieFile(artifactName, artifactArchive);
                this.deploymentListener.onDeploymentFailure(artifactName, t);
                throw t;
            }
            this.deployArtifact(artifact);
            return artifact;
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = "Failed to deploy from URL: " + artifactAchivedUrl;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private void logDeploymentFailure(Throwable t, String artifactName) {
        String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy artifact '%s', see below", artifactName));
        logger.error((Object)msg, t);
    }

    @Override
    public Map<URL, Long> getArtifactsZombieMap() {
        HashMap<URL, Long> result = new HashMap<URL, Long>();
        for (String artifact : this.artifactZombieMap.keySet()) {
            ZombieFile file = this.artifactZombieMap.get(artifact);
            result.put(file.url, file.originalTimestamp);
        }
        return result;
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<T> artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    @Override
    public void undeployArtifactWithoutUninstall(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (DeploymentException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), (Throwable)((Object)e));
            throw e;
        }
    }

    ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    @Override
    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    private T deployPackagedArtifact(URL artifactUrl, String artifactName, Optional<Properties> deploymentProperties) throws IOException {
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        if (zombieFile != null && zombieFile.isFor(artifactUrl) && !zombieFile.updatedZombieApp()) {
            return null;
        }
        Artifact artifact = (Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName));
        HashMap<Application, ApplicationStatus> appStatusPreRedeployment = new HashMap<Application, ApplicationStatus>();
        if (artifact != null) {
            if (artifact instanceof Domain) {
                Collection<Application> domainApplications = this.findApplicationsAssociated((Domain)artifact);
                for (Application domainApplication : domainApplications) {
                    appStatusPreRedeployment.put(domainApplication, domainApplication.getStatus());
                }
            }
            this.deploymentTemplate.preRedeploy(artifact);
            this.undeployArtifact(artifactName);
        }
        T deployedAtifact = this.deployPackagedArtifact(artifactUrl, deploymentProperties);
        this.deploymentTemplate.postRedeploy((Artifact)deployedAtifact, (Map<Application, ApplicationStatus>)appStatusPreRedeployment);
        return deployedAtifact;
    }

    private Collection<Application> findApplicationsAssociated(Domain domain) {
        return this.deploymentService.findDomainApplications(domain.getArtifactName());
    }

    private T deployExplodedApp(String addedApp, Optional<Properties> properties) throws DeploymentException {
        T artifact;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("================== New Exploded Artifact: " + addedApp));
        }
        try {
            artifact = this.artifactFactory.createArtifact(addedApp);
            this.trackArtifact(artifact);
        }
        catch (Throwable t) {
            File artifactDir1 = this.artifactDir;
            File artifactDir = new File(artifactDir1, addedApp);
            this.addZombieFile(addedApp, artifactDir);
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy exploded artifact: '%s', see below", addedApp));
            logger.error((Object)msg, t);
            this.deploymentListener.onDeploymentFailure(addedApp, t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy artifact: " + addedApp;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
        this.deployArtifact(artifact, properties);
        return artifact;
    }

    @Override
    public void deployArtifact(T artifact) throws DeploymentException {
        Optional properties = Optional.absent();
        this.deployArtifact(artifact, (Optional<Properties>)properties);
    }

    private void addZombieApp(Artifact artifact) {
        File resourceFile = artifact.getResourceFiles()[0];
        if (resourceFile.exists()) {
            try {
                this.artifactZombieMap.put(artifact.getArtifactName(), new ZombieFile(resourceFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addZombieFile(String artifactName, File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            this.artifactZombieMap.put(artifactName, new ZombieFile(marker));
        }
        catch (Exception e) {
            logger.debug((Object)String.format("Failed to mark an exploded artifact [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    private T findArtifact(String artifactName) {
        return (T)((Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName)));
    }

    private void trackArtifact(T artifact) {
        this.preTrackArtifact(artifact);
        this.artifacts.add(artifact);
    }

    public void preTrackArtifact(T artifact) {
        T previousArtifact = this.findArtifact(artifact.getArtifactName());
        this.artifacts.remove(previousArtifact);
    }

    private void undeploy(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.artifacts.remove(artifact);
            this.deployer.undeploy(artifact);
            this.artifactArchiveInstaller.desinstallArtifact(artifact.getArtifactName());
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
            this.logArtifactUndeployed(artifact);
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    private void logRequestToUndeployArtifact(T artifact) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("================== Request to Undeploy Artifact: " + artifact.getArtifactName()));
        }
    }

    private void logArtifactUndeployed(T artifact) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)SplashScreen.miniSplash((String)String.format("Undeployed artifact '%s'", artifact.getArtifactName())));
        }
    }

    @Override
    public void redeploy(T artifact) throws DeploymentException {
        Optional properties = Optional.absent();
        this.redeploy(artifact, (Optional<Properties>)properties);
    }

    @Override
    public void redeploy(T artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)SplashScreen.miniSplash((String)String.format("Redeploying artifact '%s'", artifact.getArtifactName())));
        }
        this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
        try {
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
        }
        this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
        try {
            artifact.setDeploymentProperties(DeploymentPropertiesUtils.resolveDeploymentProperties(artifact.getArtifactName(), deploymentProperties));
            this.deployer.deploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable t) {
            try {
                this.logDeploymentFailure(t, artifact.getArtifactName());
                this.addZombieApp((Artifact)artifact);
                if (t instanceof DeploymentException) {
                    throw (DeploymentException)((Object)t);
                }
                String msg = "Failed to deploy artifact: " + artifact.getArtifactName();
                throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
            }
            catch (Throwable throwable) {
                this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
                throw throwable;
            }
        }
        this.artifactZombieMap.remove(artifact.getArtifactName());
    }

    @Override
    public boolean isZombieArtifact(String artifactId) {
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactId);
        if (zombieFile != null) {
            if (zombieFile.exists()) {
                return true;
            }
            this.artifactZombieMap.remove(artifactId);
            return false;
        }
        return false;
    }

    @Override
    public void deployArtifact(T artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        try {
            this.trackArtifact(artifact);
            this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
            this.deployer.deploy(artifact, this.shouldStartArtifact(artifact, (Properties)deploymentProperties.orNull()));
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.artifactZombieMap.remove(artifact.getArtifactName());
        }
        catch (Throwable t) {
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy artifact '%s', see below", artifact.getArtifactName()));
            logger.error((Object)msg, t);
            this.addZombieApp((Artifact)artifact);
            this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy artifact: " + artifact.getArtifactName();
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private boolean shouldStartArtifact(T artifact, Properties deploymentProperties) {
        if (!(artifact instanceof Application) || deploymentProperties == null) {
            return true;
        }
        return Boolean.valueOf(deploymentProperties.getProperty(START_ARTIFACT_ON_DEPLOYMENT_PROPERTY, "true"));
    }

    @Override
    public T deployPackagedArtifact(String zip) throws DeploymentException {
        Optional properties = Optional.absent();
        return this.deployPackagedArtifact(zip, (Optional<Properties>)properties);
    }

    private static class ZombieFile {
        private URL url;
        private Long originalTimestamp;
        private File file;

        private ZombieFile(File file) {
            this.file = file;
            this.originalTimestamp = file.lastModified();
            try {
                this.url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean isFor(URL url) {
            return this.url.equals(url);
        }

        public boolean updatedZombieApp() {
            return this.originalTimestamp.longValue() != this.file.lastModified();
        }

        public boolean exists() {
            return this.file.exists();
        }
    }
}

