/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.ArtifactDeployer;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.artifact.Artifact;

public class DefaultArtifactDeployer<T extends Artifact>
implements ArtifactDeployer {
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public void undeploy(Artifact artifact) {
        try {
            this.tryToStopArtifact(artifact);
            this.tryToDisposeArtifact(artifact);
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = String.format("Failed to undeployArtifact artifact [%s]", artifact.getArtifactName());
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private void tryToDisposeArtifact(Artifact artifact) {
        try {
            artifact.dispose();
        }
        catch (Throwable t) {
            this.logger.error((Object)String.format("Unable to cleanly dispose artifact '%s'. Restart Mule if you get errors redeploying this artifact", artifact.getArtifactName()), t);
        }
    }

    private void tryToStopArtifact(Artifact artifact) {
        try {
            artifact.stop();
        }
        catch (Throwable t) {
            this.logger.error((Object)String.format("Unable to cleanly stop artifact '%s'. Restart Mule if you get errors redeploying this artifact", artifact.getArtifactName()), t);
        }
    }

    public void deploy(Artifact artifact) {
        try {
            artifact.install();
            artifact.init();
            artifact.start();
        }
        catch (Throwable t) {
            artifact.dispose();
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = String.format("Failed to deploy artifact [%s]", artifact.getArtifactName());
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }
}

