/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j2;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfiguratonFileWatcher;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.log4j2.MuleLoggerContext;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;

final class LoggerContextConfigurer {
    private static final String MULE_APP_LOG_FILE_TEMPLATE = "mule-app-%s.log";
    private static final String MULE_DOMAIN_LOG_FILE_TEMPLATE = "mule-domain-%s.log";
    private static final String PATTERN_LAYOUT = "%-5p %d [%t] %c: %m%n";
    private static final int DEFAULT_MONITOR_INTERVAL_SECS = 60;
    static final String FORCED_CONSOLE_APPENDER_NAME = "Forced-Console";
    static final String PER_APP_FILE_APPENDER_NAME = "defaultFileAppender";

    LoggerContextConfigurer() {
    }

    protected void configure(MuleLoggerContext context) {
        this.disableShutdownHook(context);
        this.configureMonitor(context);
    }

    protected void update(MuleLoggerContext context) {
        boolean forceConsoleLog;
        boolean bl = forceConsoleLog = System.getProperty("mule.forceConsoleLog") != null;
        if (context.getConfigFile() == null && !forceConsoleLog) {
            this.removeConsoleAppender(context);
        }
        if (context.isArtifactClassloader()) {
            this.addDefaultArtifactContext(context);
        } else if (!context.isStandlone()) {
            this.addDefaultAppender(context, "mule-main.log");
        }
        if (forceConsoleLog && !this.hasAppender(context, ConsoleAppender.class)) {
            this.forceConsoleAppender(context);
        }
    }

    private void disableShutdownHook(LoggerContext context) {
        try {
            ClassUtils.setFieldValue((Object)context.getConfiguration(), (String)"isShutdownHookEnabled", (Object)false, (boolean)true);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not configure shutdown hook. Unexpected configuration type"), (Throwable)e);
        }
    }

    private void configureMonitor(MuleLoggerContext context) {
        Configuration configuration = context.getConfiguration();
        File configFile = null;
        if (context.getConfigFile() != null) {
            configFile = new File(context.getConfigFile().getPath());
        } else if (!StringUtils.isEmpty((String)configuration.getName())) {
            configFile = new File(configuration.getName());
        }
        if (configFile != null && configuration instanceof Reconfigurable) {
            configuration.getWatchManager().setIntervalSeconds(60);
            ConfiguratonFileWatcher watcher = new ConfiguratonFileWatcher((Reconfigurable)configuration, this.getListeners(configuration));
            configuration.getWatchManager().watchFile(configFile, (FileWatcher)watcher);
        }
    }

    private List<ConfigurationListener> getListeners(Configuration configuration) {
        try {
            return (List)ClassUtils.getFieldValue((Object)configuration, (String)"listeners", (boolean)true);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not get listeners. Unexpected configuration type"), (Throwable)e);
        }
    }

    private void addDefaultAppender(MuleLoggerContext context, String logFilePath) {
        RollingFileAppender appender = this.createRollingFileAppender(logFilePath, ".%d{yyyy-MM-dd}", PER_APP_FILE_APPENDER_NAME, context.getConfiguration());
        this.doAddAppender(context, (Appender)appender);
    }

    private void forceConsoleAppender(MuleLoggerContext context) {
        ConsoleAppender appender = ConsoleAppender.createAppender(this.createLayout(context.getConfiguration()), null, null, (String)FORCED_CONSOLE_APPENDER_NAME, null, null);
        this.doAddAppender(context, (Appender)appender);
    }

    private void doAddAppender(LoggerContext context, Appender appender) {
        appender.start();
        context.getConfiguration().addAppender(appender);
        this.getRootLogger(context).addAppender(appender, Level.ALL, null);
    }

    private RollingFileAppender createRollingFileAppender(String logFilePath, String filePattern, String appenderName, Configuration configuration) {
        TimeBasedTriggeringPolicy triggeringPolicy = TimeBasedTriggeringPolicy.createPolicy((String)"1", (String)"true");
        DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.createStrategy((String)"30", (String)"1", null, (String)String.valueOf(0), null, (boolean)true, (Configuration)configuration);
        return RollingFileAppender.createAppender((String)logFilePath, (String)(logFilePath + filePattern), (String)"true", (String)appenderName, (String)"true", null, null, (TriggeringPolicy)triggeringPolicy, (RolloverStrategy)rolloverStrategy, this.createLayout(configuration), null, null, null, null, (Configuration)configuration);
    }

    private Layout<? extends Serializable> createLayout(Configuration configuration) {
        return PatternLayout.createLayout((String)PATTERN_LAYOUT, null, (Configuration)configuration, null, null, (boolean)true, (boolean)false, null, null);
    }

    private void addDefaultArtifactContext(MuleLoggerContext context) {
        String logFileNameTemplate = this.getFilenamePattern(context);
        if (logFileNameTemplate == null) {
            return;
        }
        String artifactName = context.getArtifactName();
        String logName = String.format(logFileNameTemplate, artifactName != null ? artifactName : "");
        File logDir = new File(MuleContainerBootstrapUtils.getMuleHome(), "logs");
        File logFile = new File(logDir, logName);
        if (context.getConfigLocation() == null) {
            this.addDefaultAppender(context, logFile.getAbsolutePath());
        } else if (this.isUrlInsideDirectory(context.getConfigFile(), MuleContainerBootstrapUtils.getMuleConfDir()) && !this.hasFileAppender(context)) {
            this.addDefaultAppender(context, logFile.getAbsolutePath());
            this.removeConsoleAppender(context);
        }
    }

    private void removeConsoleAppender(LoggerContext context) {
        for (Appender appender : this.getRootLogger(context).getAppenders().values()) {
            if (!(appender instanceof ConsoleAppender)) continue;
            this.removeAppender(context, appender);
            this.getRootLogger(context).removeAppender(appender.getName());
        }
    }

    private boolean hasFileAppender(LoggerContext context) {
        return this.hasAppender(context, FileAppender.class, RollingFileAppender.class, RandomAccessFileAppender.class);
    }

    private boolean hasAppender(LoggerContext context, Class<? extends Appender> ... appenderTypes) {
        for (Appender appender : this.getRootLogger(context).getAppenders().values()) {
            for (Class<? extends Appender> appenderType : appenderTypes) {
                if (!appenderType.isInstance(appender)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUrlInsideDirectory(URI uri, File directory) {
        URL url;
        if (uri == null) {
            return false;
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not locate file " + uri)), (Throwable)e);
        }
        if (directory != null && FileUtils.isFile((URL)url)) {
            File urlFile = new File(url.getFile());
            return directory.equals(urlFile.getParentFile());
        }
        return false;
    }

    private String getFilenamePattern(MuleLoggerContext context) {
        if (context.isArtifactClassloader()) {
            return context.isApplicationClassloader() ? MULE_APP_LOG_FILE_TEMPLATE : MULE_DOMAIN_LOG_FILE_TEMPLATE;
        }
        return null;
    }

    private LoggerConfig getRootLogger(LoggerContext context) {
        return ((AbstractConfiguration)context.getConfiguration()).getRootLogger();
    }

    private void removeAppender(LoggerContext context, Appender appender) {
        ((AbstractConfiguration)context.getConfiguration()).removeAppender(appender.getName());
    }
}

