/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j2;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.mule.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.reflections.ReflectionUtils;

abstract class DispatchingLogger
extends Logger {
    private final Logger originalLogger;
    private Method updateConfigurationMethod = null;
    private final ContextSelector contextSelector;
    private final int ownerClassLoaderHash;

    DispatchingLogger(Logger originalLogger, int ownerClassLoaderHash, LoggerContext loggerContext, ContextSelector contextSelector, MessageFactory messageFactory) {
        super(loggerContext, originalLogger.getName(), messageFactory);
        this.originalLogger = originalLogger;
        this.contextSelector = contextSelector;
        this.ownerClassLoaderHash = ownerClassLoaderHash;
    }

    private Logger getLogger() {
        ClassLoader currentClassLoader = ArtifactAwareContextSelector.resolveLoggerContextClassLoader(Thread.currentThread().getContextClassLoader());
        if (this.useThisLoggerContextClassLoader(currentClassLoader)) {
            return this.originalLogger;
        }
        return this.contextSelector.getContext(this.getName(), currentClassLoader, true).getLogger(this.getName(), this.getMessageFactory());
    }

    private boolean useThisLoggerContextClassLoader(ClassLoader currentClassLoader) {
        return currentClassLoader.hashCode() == this.ownerClassLoaderHash;
    }

    void updateConfiguration(Configuration config) {
        if (this.lookupUpdateConfigurationMethod()) {
            try {
                this.updateConfigurationMethod.invoke((Object)this.originalLogger, config);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean lookupUpdateConfigurationMethod() {
        Set candidateMethods;
        if (this.updateConfigurationMethod == null && (candidateMethods = ReflectionUtils.getAllMethods(this.originalLogger.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)"updateConfiguration"), ReflectionUtils.withParameters((Class[])new Class[]{Configuration.class})})).size() == 1) {
            this.updateConfigurationMethod = (Method)candidateMethods.iterator().next();
            this.updateConfigurationMethod.setAccessible(true);
        }
        return this.updateConfigurationMethod != null;
    }

    public MessageFactory getMessageFactory() {
        return this.originalLogger.getMessageFactory();
    }

    public Logger getParent() {
        return this.getLogger().getParent();
    }

    public LoggerContext getContext() {
        return this.getLogger().getContext();
    }

    public void setLevel(Level level) {
        this.getLogger().setLevel(level);
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        this.getLogger().logMessage(fqcn, level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        return this.getLogger().isEnabled(level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.getLogger().isEnabled(level, marker, message);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.getLogger().isEnabled(level, marker, message, params);
    }

    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        return this.getLogger().isEnabled(level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        return this.getLogger().isEnabled(level, marker, message, t);
    }

    public void addAppender(Appender appender) {
        this.getLogger().addAppender(appender);
    }

    public void removeAppender(Appender appender) {
        this.getLogger().removeAppender(appender);
    }

    public Map<String, Appender> getAppenders() {
        return this.getLogger().getAppenders();
    }

    public Iterator<Filter> getFilters() {
        return this.getLogger().getFilters();
    }

    public Level getLevel() {
        return this.getLogger().getLevel();
    }

    public int filterCount() {
        return this.getLogger().filterCount();
    }

    public void addFilter(Filter filter) {
        this.getLogger().addFilter(filter);
    }

    public boolean isAdditive() {
        return this.getLogger().isAdditive();
    }

    public void setAdditive(boolean additive) {
        this.getLogger().setAdditive(additive);
    }

    public String toString() {
        return this.getLogger().toString();
    }

    public static void checkMessageFactory(ExtendedLogger logger, MessageFactory messageFactory) {
        AbstractLogger.checkMessageFactory((ExtendedLogger)logger, (MessageFactory)messageFactory);
    }

    public void catching(Level level, Throwable t) {
        this.getLogger().catching(level, t);
    }

    public void catching(Throwable t) {
        this.getLogger().catching(t);
    }

    public void debug(Marker marker, Message msg) {
        this.getLogger().debug(marker, msg);
    }

    public void debug(Marker marker, Message msg, Throwable t) {
        this.getLogger().debug(marker, msg, t);
    }

    public void debug(Marker marker, Object message) {
        this.getLogger().debug(marker, message);
    }

    public void debug(Marker marker, Object message, Throwable t) {
        this.getLogger().debug(marker, message, t);
    }

    public void debug(Marker marker, String message) {
        this.getLogger().debug(marker, message);
    }

    public void debug(Marker marker, String message, Object ... params) {
        this.getLogger().debug(marker, message, params);
    }

    public void debug(Marker marker, String message, Throwable t) {
        this.getLogger().debug(marker, message, t);
    }

    public void debug(Message msg) {
        this.getLogger().debug(msg);
    }

    public void debug(Message msg, Throwable t) {
        this.getLogger().debug(msg, t);
    }

    public void debug(Object message) {
        this.getLogger().debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.getLogger().debug(message, t);
    }

    public void debug(String message) {
        this.getLogger().debug(message);
    }

    public void debug(String message, Object ... params) {
        this.getLogger().debug(message, params);
    }

    public void debug(String message, Throwable t) {
        this.getLogger().debug(message, t);
    }

    public void entry() {
        this.getLogger().entry();
    }

    public void entry(Object ... params) {
        this.getLogger().entry(params);
    }

    public void entry(String fqcn, Object ... params) {
        this.getLogger().entry(new Object[]{fqcn, params});
    }

    public void error(Marker marker, Message msg) {
        this.getLogger().error(marker, msg);
    }

    public void error(Marker marker, Message msg, Throwable t) {
        this.getLogger().error(marker, msg, t);
    }

    public void error(Marker marker, Object message) {
        this.getLogger().error(marker, message);
    }

    public void error(Marker marker, Object message, Throwable t) {
        this.getLogger().error(marker, message, t);
    }

    public void error(Marker marker, String message) {
        this.getLogger().error(marker, message);
    }

    public void error(Marker marker, String message, Object ... params) {
        this.getLogger().error(marker, message, params);
    }

    public void error(Marker marker, String message, Throwable t) {
        this.getLogger().error(marker, message, t);
    }

    public void error(Message msg) {
        this.getLogger().error(msg);
    }

    public void error(Message msg, Throwable t) {
        this.getLogger().error(msg, t);
    }

    public void error(Object message) {
        this.getLogger().error(message);
    }

    public void error(Object message, Throwable t) {
        this.getLogger().error(message, t);
    }

    public void error(String message) {
        this.getLogger().error(message);
    }

    public void error(String message, Object ... params) {
        this.getLogger().error(message, params);
    }

    public void error(String message, Throwable t) {
        this.getLogger().error(message, t);
    }

    public void exit() {
        this.getLogger().exit();
    }

    public <R> R exit(R result) {
        return (R)this.getLogger().exit(result);
    }

    public void fatal(Marker marker, Message msg) {
        this.getLogger().fatal(marker, msg);
    }

    public void fatal(Marker marker, Message msg, Throwable t) {
        this.getLogger().fatal(marker, msg, t);
    }

    public void fatal(Marker marker, Object message) {
        this.getLogger().fatal(marker, message);
    }

    public void fatal(Marker marker, Object message, Throwable t) {
        this.getLogger().fatal(marker, message, t);
    }

    public void fatal(Marker marker, String message) {
        this.getLogger().fatal(marker, message);
    }

    public void fatal(Marker marker, String message, Object ... params) {
        this.getLogger().fatal(marker, message, params);
    }

    public void fatal(Marker marker, String message, Throwable t) {
        this.getLogger().fatal(marker, message, t);
    }

    public void fatal(Message msg) {
        this.getLogger().fatal(msg);
    }

    public void fatal(Message msg, Throwable t) {
        this.getLogger().fatal(msg, t);
    }

    public void fatal(Object message) {
        this.getLogger().fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.getLogger().fatal(message, t);
    }

    public void fatal(String message) {
        this.getLogger().fatal(message);
    }

    public void fatal(String message, Object ... params) {
        this.getLogger().fatal(message, params);
    }

    public void fatal(String message, Throwable t) {
        this.getLogger().fatal(message, t);
    }

    public void info(Marker marker, Message msg) {
        this.getLogger().info(marker, msg);
    }

    public void info(Marker marker, Message msg, Throwable t) {
        this.getLogger().info(marker, msg, t);
    }

    public void info(Marker marker, Object message) {
        this.getLogger().info(marker, message);
    }

    public void info(Marker marker, Object message, Throwable t) {
        this.getLogger().info(marker, message, t);
    }

    public void info(Marker marker, String message) {
        this.getLogger().info(marker, message);
    }

    public void info(Marker marker, String message, Object ... params) {
        this.getLogger().info(marker, message, params);
    }

    public void info(Marker marker, String message, Throwable t) {
        this.getLogger().info(marker, message, t);
    }

    public void info(Message msg) {
        this.getLogger().info(msg);
    }

    public void info(Message msg, Throwable t) {
        this.getLogger().info(msg, t);
    }

    public void info(Object message) {
        this.getLogger().info(message);
    }

    public void info(Object message, Throwable t) {
        this.getLogger().info(message, t);
    }

    public void info(String message) {
        this.getLogger().info(message);
    }

    public void info(String message, Object ... params) {
        this.getLogger().info(message, params);
    }

    public void info(String message, Throwable t) {
        this.getLogger().info(message, t);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.getLogger().isDebugEnabled(marker);
    }

    public boolean isEnabled(Level level) {
        return this.getLogger().isEnabled(level);
    }

    public boolean isEnabled(Level level, Marker marker) {
        return this.getLogger().isEnabled(level, marker);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.getLogger().isErrorEnabled(marker);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isFatalEnabled();
    }

    public boolean isFatalEnabled(Marker marker) {
        return this.getLogger().isFatalEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.getLogger().isInfoEnabled(marker);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.getLogger().isTraceEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.getLogger().isWarnEnabled(marker);
    }

    public void log(Level level, Marker marker, Message msg) {
        this.getLogger().log(level, marker, msg);
    }

    public void log(Level level, Marker marker, Message msg, Throwable t) {
        this.getLogger().log(level, marker, msg, t);
    }

    public void log(Level level, Marker marker, Object message) {
        this.getLogger().log(level, marker, message);
    }

    public void log(Level level, Marker marker, Object message, Throwable t) {
        this.getLogger().log(level, marker, message, t);
    }

    public void log(Level level, Marker marker, String message) {
        this.getLogger().log(level, marker, message);
    }

    public void log(Level level, Marker marker, String message, Object ... params) {
        this.getLogger().log(level, marker, message, params);
    }

    public void log(Level level, Marker marker, String message, Throwable t) {
        this.getLogger().log(level, marker, message, t);
    }

    public void log(Level level, Message msg) {
        this.getLogger().log(level, msg);
    }

    public void log(Level level, Message msg, Throwable t) {
        this.getLogger().log(level, msg, t);
    }

    public void log(Level level, Object message) {
        this.getLogger().log(level, message);
    }

    public void log(Level level, Object message, Throwable t) {
        this.getLogger().log(level, message, t);
    }

    public void log(Level level, String message) {
        this.getLogger().log(level, message);
    }

    public void log(Level level, String message, Object ... params) {
        this.getLogger().log(level, message, params);
    }

    public void log(Level level, String message, Throwable t) {
        this.getLogger().log(level, message, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, Message msg, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, msg, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, Object message, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object ... params) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, params);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, t);
    }

    public void printf(Level level, Marker marker, String format, Object ... params) {
        this.getLogger().printf(level, marker, format, params);
    }

    public void printf(Level level, String format, Object ... params) {
        this.getLogger().printf(level, format, params);
    }

    public <T extends Throwable> T throwing(T t) {
        return (T)this.getLogger().throwing(t);
    }

    public <T extends Throwable> T throwing(Level level, T t) {
        return (T)this.getLogger().throwing(level, t);
    }

    public void trace(Marker marker, Message msg) {
        this.getLogger().trace(marker, msg);
    }

    public void trace(Marker marker, Message msg, Throwable t) {
        this.getLogger().trace(marker, msg, t);
    }

    public void trace(Marker marker, Object message) {
        this.getLogger().trace(marker, message);
    }

    public void trace(Marker marker, Object message, Throwable t) {
        this.getLogger().trace(marker, message, t);
    }

    public void trace(Marker marker, String message) {
        this.getLogger().trace(marker, message);
    }

    public void trace(Marker marker, String message, Object ... params) {
        this.getLogger().trace(marker, message, params);
    }

    public void trace(Marker marker, String message, Throwable t) {
        this.getLogger().trace(marker, message, t);
    }

    public void trace(Message msg) {
        this.getLogger().trace(msg);
    }

    public void trace(Message msg, Throwable t) {
        this.getLogger().trace(msg, t);
    }

    public void trace(Object message) {
        this.getLogger().trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.getLogger().trace(message, t);
    }

    public void trace(String message) {
        this.getLogger().trace(message);
    }

    public void trace(String message, Object ... params) {
        this.getLogger().trace(message, params);
    }

    public void trace(String message, Throwable t) {
        this.getLogger().trace(message, t);
    }

    public void warn(Marker marker, Message msg) {
        this.getLogger().warn(marker, msg);
    }

    public void warn(Marker marker, Message msg, Throwable t) {
        this.getLogger().warn(marker, msg, t);
    }

    public void warn(Marker marker, Object message) {
        this.getLogger().warn(marker, message);
    }

    public void warn(Marker marker, Object message, Throwable t) {
        this.getLogger().warn(marker, message, t);
    }

    public void warn(Marker marker, String message) {
        this.getLogger().warn(marker, message);
    }

    public void warn(Marker marker, String message, Object ... params) {
        this.getLogger().warn(marker, message, params);
    }

    public void warn(Marker marker, String message, Throwable t) {
        this.getLogger().warn(marker, message, t);
    }

    public void warn(Message msg) {
        this.getLogger().warn(msg);
    }

    public void warn(Message msg, Throwable t) {
        this.getLogger().warn(msg, t);
    }

    public void warn(Object message) {
        this.getLogger().warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.getLogger().warn(message, t);
    }

    public void warn(String message) {
        this.getLogger().warn(message);
    }

    public void warn(String message, Object ... params) {
        this.getLogger().warn(message, params);
    }

    public void warn(String message, Throwable t) {
        this.getLogger().warn(message, t);
    }
}

