/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.launcher.DirectoryResourceLocator;
import org.mule.module.launcher.LocalResourceLocator;
import org.mule.module.launcher.application.ApplicationClassLoader;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.ShutdownListener;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.module.reboot.MuleContainerSystemClassLoader;
import org.mule.util.FileUtils;

public class ArtifactAwareRepositorySelector
implements RepositorySelector {
    protected static final String PATTERN_LAYOUT = "%-5p %d [%t] %c: %m%n";
    protected static final Integer NO_CCL_CLASSLOADER = 0;
    public static final String MULE_APP_LOG_FILE_TEMPLATE = "mule-app-%s.log";
    protected LoggerRepositoryCache cache = new LoggerRepositoryCache();
    protected Logger logger = Logger.getLogger(this.getClass());
    protected final ThreadLocal<LoggerRepository> repositoryUnderConstruction = new ThreadLocal();

    public LoggerRepository getLoggerRepository() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        LoggerRepository repository = this.repositoryUnderConstruction.get();
        if (repository != null) {
            return repository;
        }
        repository = this.cache.getLoggerRepository(ccl);
        if (repository == null) {
            RootLogger root = new RootLogger(Level.INFO);
            repository = new Hierarchy((Logger)root);
            this.repositoryUnderConstruction.set(repository);
            try {
                ConfigWatchDog configWatchDog = null;
                if (ccl instanceof ArtifactClassLoader) {
                    String logFileNamePatter = ccl instanceof ApplicationClassLoader ? MULE_APP_LOG_FILE_TEMPLATE : "mule-domain-%s.log";
                    configWatchDog = this.configureLoggerAndRetrieveWatchdog((ArtifactClassLoader)((Object)ccl), repository, root, configWatchDog, logFileNamePatter);
                } else if (MuleContainerBootstrapUtils.getMuleConfDir() != null) {
                    URL rootLogConfig = this.getLogConfig(new DirectoryResourceLocator(MuleContainerBootstrapUtils.getMuleConfDir().getAbsolutePath()));
                    this.configureFrom(rootLogConfig, repository);
                    if (ccl instanceof MuleContainerSystemClassLoader) {
                        configWatchDog = new ConfigWatchDog(ccl, rootLogConfig.getFile(), repository);
                        configWatchDog.setName("Mule.system.log4j.config.monitor");
                    }
                } else {
                    this.addDefaultAppender(root, "mule-main.log", null);
                }
                LoggerRepository previous = this.cache.storeLoggerRepository(ccl, repository);
                if (previous != null) {
                    repository = previous;
                } else if (configWatchDog != null) {
                    configWatchDog.start();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.repositoryUnderConstruction.remove();
            }
        }
        return repository;
    }

    private ConfigWatchDog configureLoggerAndRetrieveWatchdog(ArtifactClassLoader artifactClassLoader, LoggerRepository repository, RootLogger root, ConfigWatchDog configWatchDog, String logFileNameTemplate) throws IOException {
        URL artifactLogConfig = this.getArtifactLoggingConfig(artifactClassLoader);
        String artifactName = artifactClassLoader.getArtifactName();
        if (artifactLogConfig == null) {
            this.addDefaultAppender(root, logFileNameTemplate, artifactName);
        } else {
            this.configureFrom(artifactLogConfig, repository);
            if (FileUtils.isFile((URL)artifactLogConfig)) {
                configWatchDog = new ConfigWatchDog(artifactClassLoader.getClassLoader(), artifactLogConfig.getFile(), repository);
                configWatchDog.setName(String.format("[%s].log4j.config.monitor", artifactName));
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Logging config %s is not an external file, will not be monitored for changes", artifactLogConfig));
            }
            if (this.isUrlInsideDirectory(artifactLogConfig, MuleContainerBootstrapUtils.getMuleConfDir()) && !this.hasFileAppender(root, artifactName)) {
                this.addDefaultAppender(root, logFileNameTemplate, artifactName);
                this.removeConsoleAppenders(root);
            }
        }
        return configWatchDog;
    }

    private boolean isUrlInsideDirectory(URL url, File directory) {
        if (directory != null && FileUtils.isFile((URL)url)) {
            File urlFile = new File(url.getFile());
            return directory.equals(urlFile.getParentFile());
        }
        return false;
    }

    private void removeConsoleAppenders(RootLogger root) {
        ArrayList<Appender> appendersToRemove = new ArrayList<Appender>();
        Enumeration appenders = root.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof ConsoleAppender)) continue;
            appendersToRemove.add(appender);
        }
        for (Appender appender : appendersToRemove) {
            root.removeAppender(appender);
        }
    }

    private boolean hasFileAppender(RootLogger root, String artifactName) {
        Enumeration appenders = root.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender) || !((FileAppender)appender).getFile().contains(artifactName)) continue;
            return true;
        }
        return false;
    }

    private void addDefaultAppender(RootLogger root, String logFileNameTemplate, String artifactName) throws IOException {
        String logName = String.format(logFileNameTemplate, artifactName != null ? artifactName : "");
        File logDir = new File(MuleContainerBootstrapUtils.getMuleHome(), "logs");
        File logFile = new File(logDir, logName);
        DailyRollingFileAppender fileAppender = new DailyRollingFileAppender((Layout)new PatternLayout(PATTERN_LAYOUT), logFile.getAbsolutePath(), "'.'yyyy-MM-dd");
        fileAppender.setName("defaultFileAppender");
        fileAppender.setAppend(true);
        fileAppender.activateOptions();
        root.addAppender((Appender)fileAppender);
    }

    private URL getArtifactLoggingConfig(ArtifactClassLoader muleCL) {
        URL appLogConfig = this.getLogConfig(muleCL);
        if (appLogConfig != null && this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Found logging config for application '%s' at '%s'", muleCL.getArtifactName(), appLogConfig));
        }
        return appLogConfig;
    }

    private URL getLogConfig(LocalResourceLocator localResourceLocator) {
        URL appLogConfig = localResourceLocator.findLocalResource("log4j.xml");
        if (appLogConfig == null) {
            appLogConfig = localResourceLocator.findLocalResource("log4j.properties");
        }
        return appLogConfig;
    }

    protected void configureFrom(URL url, LoggerRepository repository) {
        if (url.toExternalForm().endsWith(".xml")) {
            new DOMConfigurator().doConfigure(url, repository);
        } else {
            new PropertyConfigurator().doConfigure(url, repository);
        }
    }

    protected class ConfigWatchDog
    extends Thread {
        protected LoggerRepository repository;
        protected File file;
        protected long lastModif = 0L;
        protected boolean warnedAlready = false;
        protected volatile boolean interrupted = false;
        public static final long DEFAULT_DELAY = 60000L;
        protected String filename;
        protected long delay = 60000L;

        public ConfigWatchDog(ClassLoader classLoader, String filename, LoggerRepository repository) {
            if (classLoader instanceof ArtifactClassLoader) {
                ((ArtifactClassLoader)((Object)classLoader)).addShutdownListener(new ShutdownListener(){

                    @Override
                    public void execute() {
                        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                        ArtifactAwareRepositorySelector.this.cache.remove(ccl);
                        ConfigWatchDog.this.interrupt();
                    }
                });
            } else if (!(classLoader instanceof MuleContainerSystemClassLoader)) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Can't create a ConfigWatchDog thread for current class loader of type %s", (Object[])new Object[]{classLoader.getClass().getName()}));
            }
            this.filename = filename;
            this.file = new File(filename);
            this.lastModif = this.file.lastModified();
            this.setDaemon(true);
            this.repository = repository;
            this.delay = 10000L;
        }

        public void doOnChange() {
            if (ArtifactAwareRepositorySelector.this.logger.isInfoEnabled()) {
                ArtifactAwareRepositorySelector.this.logger.info((Object)("Reconfiguring logging from: " + this.filename));
            }
            if (this.filename.endsWith(".xml")) {
                new DOMConfigurator().doConfigure(this.filename, this.repository);
            } else {
                new PropertyConfigurator().doConfigure(this.filename, this.repository);
            }
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        protected void checkAndConfigure() {
            boolean fileExists;
            try {
                fileExists = this.file.exists();
            }
            catch (SecurityException e) {
                LogLog.warn((String)("Was not allowed to read check file existence, file:[" + this.filename + "]."));
                this.interrupted = true;
                return;
            }
            if (fileExists) {
                long l = this.file.lastModified();
                if (l > this.lastModif) {
                    this.lastModif = l;
                    this.doOnChange();
                    this.warnedAlready = false;
                }
            } else if (!this.warnedAlready) {
                LogLog.debug((String)("[" + this.filename + "] does not exist."));
                this.warnedAlready = true;
            }
        }

        @Override
        public void run() {
            while (!this.interrupted) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    this.interrupted = true;
                    Thread.currentThread().interrupt();
                    break;
                }
                this.checkAndConfigure();
            }
            if (ArtifactAwareRepositorySelector.this.logger.isDebugEnabled()) {
                ArtifactAwareRepositorySelector.this.logger.debug((Object)(this.getName() + " terminated successfully"));
            }
        }
    }

    protected static class LoggerRepositoryCache {
        protected ConcurrentMap<Integer, LoggerRepository> repositories = new ConcurrentHashMap<Integer, LoggerRepository>();

        protected LoggerRepositoryCache() {
        }

        public LoggerRepository getLoggerRepository(ClassLoader classLoader) {
            return (LoggerRepository)this.repositories.get(this.computeKey(classLoader));
        }

        public LoggerRepository storeLoggerRepository(ClassLoader classLoader, LoggerRepository repository) {
            return this.repositories.putIfAbsent(this.computeKey(classLoader), repository);
        }

        public void remove(ClassLoader classLoader) {
            this.repositories.remove(this.computeKey(classLoader));
        }

        protected Integer computeKey(ClassLoader classLoader) {
            return classLoader == null ? NO_CCL_CLASSLOADER.intValue() : classLoader.hashCode();
        }
    }
}

