/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.GoodCitizenClassLoader;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.SystemUtils;

public class MuleSharedDomainClassLoader
extends GoodCitizenClassLoader
implements ArtifactClassLoader {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DOMAIN_LIBRARY_FOLDER = "lib";
    public static final String OLD_DOMAIN_LIBRARY_FOLDER = "lib" + File.separator + "shared";
    private final String domain;
    private File domainDir;
    private File domainLibraryFolder;

    public MuleSharedDomainClassLoader(String domain, ClassLoader parent) {
        super(new URL[0], parent);
        try {
            if (domain == null) {
                throw new IllegalArgumentException("Domain name cannot be null");
            }
            this.domain = domain;
            this.validateAndGetDomainFolders();
            this.addURL(this.domainLibraryFolder.getParentFile().toURI().toURL());
            if (this.domainLibraryFolder.exists()) {
                Collection jars = FileUtils.listFiles((File)this.domainLibraryFolder, (String[])new String[]{"jar"}, (boolean)false);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Loading Shared ClassLoader Domain: ").append(domain).append(SystemUtils.LINE_SEPARATOR);
                    sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                    for (File jar : jars) {
                        sb.append(jar.toURI().toURL()).append(SystemUtils.LINE_SEPARATOR);
                    }
                    sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                    this.logger.debug((Object)sb.toString());
                }
                for (File jar : jars) {
                    this.addURL(jar.toURI().toURL());
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.domain, Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    public String getArtifactName() {
        return this.domain;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public void dispose() {
    }

    @Override
    public URL findResource(String name) {
        File file;
        URL resource = super.findResource(name);
        if (resource == null && (file = new File(this.domainDir + File.separator + name)).exists()) {
            try {
                resource = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.logger.debug((Object)"Failure looking for resource", (Throwable)e);
            }
        }
        return resource;
    }

    private void validateAndGetDomainFolders() throws Exception {
        File oldDomainDir = new File(MuleContainerBootstrapUtils.getMuleHome(), OLD_DOMAIN_LIBRARY_FOLDER + File.separator + this.domain);
        if (oldDomainDir.exists()) {
            if (!oldDomainDir.canRead()) {
                throw new IllegalArgumentException(String.format("Shared ClassLoader Domain '%s' is not accessible", this.domain));
            }
            this.domainLibraryFolder = oldDomainDir;
            this.domainDir = oldDomainDir;
            return;
        }
        File newDomainDir = new File(MuleContainerBootstrapUtils.getMuleDomainsDir() + File.separator + this.domain);
        if (!newDomainDir.exists()) {
            throw new IllegalArgumentException(String.format("Domain '%s' is not accessible", this.domain));
        }
        if (!newDomainDir.canRead()) {
            throw new IllegalArgumentException(String.format("Domain '%s' is not accessible", this.domain));
        }
        this.domainDir = newDomainDir;
        this.domainLibraryFolder = new File(newDomainDir, DOMAIN_LIBRARY_FOLDER);
        this.logger.info((Object)String.format("Using domain dir %s for domain %s", this.domainDir.getAbsolutePath(), this.domain));
    }
}

