/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;

public class ArtifactArchiveInstaller {
    protected static final String ANCHOR_FILE_BLURB = "Delete this file while Mule is running to undeployArtifact this artifact in a clean way.";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private final File artifactParentDir;

    public ArtifactArchiveInstaller(File artifactParentDir) {
        this.artifactParentDir = artifactParentDir;
    }

    public String installArtifact(URL artifactUrl) throws IOException {
        String artifactName;
        if (!artifactUrl.toString().endsWith(".zip")) {
            throw new IllegalArgumentException("Invalid Mule artifact archive: " + artifactUrl);
        }
        String baseName = FilenameUtils.getBaseName((String)artifactUrl.toString());
        if (baseName.contains("%20")) {
            throw new DeploymentInitException(MessageFactory.createStaticMessage((String)("Mule artifact name may not contain spaces: " + baseName)));
        }
        File artifactDir = null;
        boolean errorEncountered = false;
        try {
            String fullPath = artifactUrl.toURI().toString();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Exploding a Mule artifact archive: " + fullPath));
            }
            artifactName = FilenameUtils.getBaseName((String)fullPath);
            artifactDir = new File(this.artifactParentDir, artifactName);
            File source = new File(artifactUrl.toURI());
            FileUtils.unzip((File)source, (File)artifactDir);
            if ("file".equals(artifactUrl.getProtocol())) {
                FileUtils.deleteQuietly((File)source);
            }
            this.installExplodedArtifact(artifactName);
        }
        catch (URISyntaxException e) {
            errorEncountered = true;
            IOException ex = new IOException(e.getMessage());
            ex.fillInStackTrace();
            throw ex;
        }
        catch (IOException e) {
            errorEncountered = true;
            throw e;
        }
        catch (Throwable t) {
            errorEncountered = true;
            String msg = "Failed to install artifact from URL: " + artifactUrl;
            throw new DeploymentInitException(MessageFactory.createStaticMessage((String)msg), t);
        }
        finally {
            if (errorEncountered && artifactDir != null && artifactDir.exists()) {
                FileUtils.deleteTree((File)artifactDir);
            }
        }
        return artifactName;
    }

    public void desinstallArtifact(String artifactName) {
        try {
            File artifactDir = new File(this.artifactParentDir, artifactName);
            FileUtils.deleteDirectory((File)artifactDir);
            File marker = this.getArtifactMarkerFile(artifactName);
            marker.delete();
            Introspector.flushCaches();
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = String.format("Failed to undeployArtifact artifact [%s]", artifactName);
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    public void installExplodedArtifact(String artifactName) throws IOException {
        this.createMarkerFile(artifactName);
    }

    private File getArtifactMarkerFile(String artifactName) {
        return new File(this.artifactParentDir, String.format("%s%s", artifactName, "-anchor.txt"));
    }

    private void createMarkerFile(String artifactName) throws IOException {
        File marker = this.getArtifactMarkerFile(artifactName);
        FileUtils.writeStringToFile((File)marker, (String)ANCHOR_FILE_BLURB);
    }
}

