/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentStatusTracker;
import org.mule.module.launcher.SimpleLoggingTable;

public class StartupSummaryDeploymentListener
implements DeploymentService.StartupListener {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected DeploymentStatusTracker tracker;

    public StartupSummaryDeploymentListener(DeploymentStatusTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public void onAfterStartup() {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        Map<String, DeploymentStatusTracker.DeploymentState> applicationStates = this.tracker.getDeploymentStates();
        if (applicationStates.isEmpty()) {
            return;
        }
        SimpleLoggingTable applicationTable = new SimpleLoggingTable();
        applicationTable.addColumn("APPLICATION", 45);
        applicationTable.addColumn("STATUS", 18);
        for (String app : applicationStates.keySet()) {
            String[] data = new String[]{app, applicationStates.get(app).toString()};
            applicationTable.addDataRow(data);
        }
        String message = String.format("%n%n%s", applicationTable);
        this.logger.info((Object)message);
    }
}

