/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DescriptorParser;
import org.mule.util.StringUtils;

public class PropertiesDescriptorParser
implements DescriptorParser {
    public ApplicationDescriptor parse(File descriptor) throws IOException {
        Properties p = new Properties();
        p.load(new FileInputStream(descriptor));
        ApplicationDescriptor d = new ApplicationDescriptor();
        d.setEncoding(p.getProperty("encoding"));
        d.setConfigurationBuilder(p.getProperty("config.builder"));
        d.setDomain(p.getProperty("domain"));
        d.setParentFirstClassLoader(BooleanUtils.toBoolean((String)p.getProperty("classloader.parentFirst", Boolean.TRUE.toString())));
        String resProps = p.getProperty("config.resources");
        String[] urls = StringUtils.isBlank((String)resProps) ? new String[]{"mule-config.xml"} : resProps.split(",");
        d.setConfigResources(urls);
        d.setRedeploymentEnabled(BooleanUtils.toBoolean((String)p.getProperty("redeployment.enabled", Boolean.TRUE.toString())));
        return d;
    }

    public String getSupportedFormat() {
        return "properties";
    }
}

