/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.config.ExceptionHelper;
import org.mule.config.StartupContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.module.launcher.DefaultMuleDeployer;
import org.mule.module.launcher.MuleContainerStartupSplashScreen;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

public class MuleContainer {
    public static final String[][] CLI_OPTIONS = new String[][]{{"builder", "true", "Configuration Builder Type"}, {"config", "true", "Configuration File"}, {"idle", "false", "Whether to run in idle (unconfigured) mode"}, {"main", "true", "Main Class"}, {"mode", "true", "Run Mode"}, {"props", "true", "Startup Properties"}, {"production", "false", "Production Mode"}, {"debug", "false", "Configure Mule for JPDA remote debugging."}, {"app", "true", "Application to start"}};
    protected static final String CLASSNAME_DEFAULT_CONFIG_BUILDER = "org.mule.config.builders.AutoConfigurationBuilder";
    protected static final String CLASSNAME_DEFAULT_IDLE_CONFIG_BUILDER = "org.mule.config.builders.MuleIdleConfigurationBuilder";
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = "org.mule.config.AnnotationsConfigurationBuilder";
    private static final Log logger = LogFactory.getLog(MuleContainer.class);
    public static final String DEFAULT_CONFIGURATION = "mule-config.xml";
    private String configurationResources = null;
    private static String configBuilderClassName = null;
    private static String startupPropertiesFile = null;
    private static MuleShutdownHook muleShutdownHook;
    protected DefaultMuleDeployer deployer;

    public static void main(String[] args) throws Exception {
        MuleContainer container = new MuleContainer(args);
        container.start(false, true);
    }

    public MuleContainer() {
        this.init(new String[0]);
    }

    public MuleContainer(String configResources) {
        this.init(new String[]{"-config", configResources});
    }

    public MuleContainer(String[] args) throws IllegalArgumentException {
        this.init(args);
    }

    protected void init(String[] args) throws IllegalArgumentException {
        Map commandlineOptions;
        try {
            commandlineOptions = SystemUtils.getCommandLineOptions((String[])args, (String[][])CLI_OPTIONS);
        }
        catch (DefaultMuleException me) {
            throw new IllegalArgumentException(me.toString());
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        String propertiesFile = (String)commandlineOptions.get("props");
        if (propertiesFile != null) {
            MuleContainer.setStartupPropertiesFile(propertiesFile);
        }
        StartupContext.get().setStartupOptions(commandlineOptions);
    }

    public void start(boolean ownThread, boolean registerShutdownHook) {
        if (registerShutdownHook) {
            this.registerShutdownHook();
        }
        MuleContainerStartupSplashScreen splashScreen = new MuleContainerStartupSplashScreen();
        splashScreen.doBody();
        logger.info((Object)splashScreen.toString());
        try {
            this.deployer = new DefaultMuleDeployer();
            this.deployer.deploy();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    public void shutdown(Throwable e) {
        Message msg = CoreMessages.fatalErrorWhileRunning();
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)e);
        if (muleException != null) {
            logger.fatal((Object)muleException.getDetailedMessage());
        } else {
            logger.fatal((Object)(msg.toString() + " " + e.getMessage()), e);
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(msg.getMessage());
        Throwable root = ExceptionHelper.getRootException((Throwable)e);
        msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
        msgs.add(" ");
        msgs.add(CoreMessages.fatalErrorInShutdown().getMessage());
        String shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)80);
        logger.fatal((Object)shutdownMessage);
        this.unregisterShutdownHook();
        this.doShutdown();
    }

    public void shutdown() {
        logger.info((Object)"Mule container shutting down due to normal shutdown request");
        this.unregisterShutdownHook();
        this.doShutdown();
    }

    protected void doShutdown() {
        if (this.deployer != null) {
            this.deployer.dispose();
        }
        System.exit(0);
    }

    public Log getLogger() {
        return logger;
    }

    public void registerShutdownHook() {
        if (muleShutdownHook == null) {
            muleShutdownHook = new MuleShutdownHook();
        } else {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
        Runtime.getRuntime().addShutdownHook(muleShutdownHook);
    }

    public void unregisterShutdownHook() {
        if (muleShutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
    }

    public String getConfigurationResources() {
        return this.configurationResources;
    }

    public static String getStartupPropertiesFile() {
        return startupPropertiesFile;
    }

    public static void setStartupPropertiesFile(String startupPropertiesFile) {
        MuleContainer.startupPropertiesFile = startupPropertiesFile;
    }

    private class MuleShutdownHook
    extends Thread {
        public void run() {
            MuleContainer.this.doShutdown();
        }
    }
}

