/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.FileUtils;
import org.mule.util.SystemUtils;

public class MuleApplicationClassLoader
extends URLClassLoader {
    public static final String PATH_LIBRARY = "lib";
    public static final String PATH_CLASSES = "classes";
    protected static final URL[] CLASSPATH_EMPTY = new URL[0];
    protected final transient Log logger;
    private String appName;

    public MuleApplicationClassLoader(String appName, ClassLoader parentCl) {
        block7: {
            super(CLASSPATH_EMPTY, parentCl);
            this.logger = LogFactory.getLog(this.getClass());
            this.appName = appName;
            try {
                String muleHome = System.getProperty("mule.home");
                String configPath = String.format("%s/apps/%s", muleHome, appName);
                File parentFile = new File(configPath);
                File classesDir = new File(parentFile, PATH_CLASSES);
                this.addURL(classesDir.toURI().toURL());
                File libDir = new File(parentFile, PATH_LIBRARY);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)String.format("[%s] Library directory: %s", appName, libDir));
                }
                if (libDir.exists() && libDir.canRead()) {
                    Collection jars = FileUtils.listFiles((File)libDir, (String[])new String[]{"jar"}, (boolean)false);
                    if (!jars.isEmpty() && this.logger.isInfoEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(String.format("[%s] Loading the following jars:", appName)).append(SystemUtils.LINE_SEPARATOR);
                        sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                        for (File jar : jars) {
                            sb.append(jar.toURI().toURL()).append(SystemUtils.LINE_SEPARATOR);
                        }
                        sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                        this.logger.info((Object)sb.toString());
                    }
                    for (File jar : jars) {
                        this.addURL(jar.toURI().toURL());
                    }
                }
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) break block7;
                this.logger.debug((Object)String.format("[%s]", appName), (Throwable)e);
            }
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.appName, Integer.toHexString(System.identityHashCode(this)));
    }
}

