/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.config.StartupContext;
import org.mule.module.launcher.Application;
import org.mule.module.launcher.ApplicationWrapper;
import org.mule.module.launcher.DefaultMuleApplication;
import org.mule.module.reboot.MuleContainerBootstrapUtils;

public class DefaultMuleDeployer {
    private List<Application> applications = new ArrayList<Application>();

    public void deploy() {
        Map options = StartupContext.get().getStartupOptions();
        String appString = (String)options.get("app");
        String[] apps = appString == null ? MuleContainerBootstrapUtils.getMuleAppsFile().list() : appString.split(":");
        for (String app : apps) {
            ApplicationWrapper<Map<String, Object>> a = new ApplicationWrapper<Map<String, Object>>(new DefaultMuleApplication(app));
            a.setMetaData(options);
            this.applications.add(a);
        }
        for (Application application : this.applications) {
            try {
                application.install();
                application.init();
                application.start();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void dispose() {
        Collections.reverse(this.applications);
        for (Application application : this.applications) {
            try {
                application.stop();
                application.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

