/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.SystemUtils;

public class MuleSharedDomainClassLoader
extends URLClassLoader {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final String domain = "undefined";

    public MuleSharedDomainClassLoader(String domain, ClassLoader parent) {
        super(new URL[0], parent);
        try {
            File domainDir = new File(MuleContainerBootstrapUtils.getMuleHomeFile(), "lib/shared/" + domain);
            if (!domainDir.exists()) {
                throw new IllegalArgumentException(String.format("Shared ClassLoader Domain '%s' doesn't exist", domain));
            }
            if (!domainDir.canRead()) {
                throw new IllegalArgumentException(String.format("Shared ClassLoader Domain '%s' is not accessible", domain));
            }
            Collection jars = FileUtils.listFiles((File)domainDir, (String[])new String[]{"jar"}, (boolean)false);
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Loading Shared ClassLoader Domain: ").append(domain).append(SystemUtils.LINE_SEPARATOR);
                sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                for (File jar : jars) {
                    sb.append(jar.toURI().toURL()).append(SystemUtils.LINE_SEPARATOR);
                }
                sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                this.logger.debug((Object)sb.toString());
            }
            for (File jar : jars) {
                this.addURL(jar.toURI().toURL());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getDomain() {
        return "undefined";
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), "undefined", Integer.toHexString(System.identityHashCode(this)));
    }
}

