/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.transformers;

import de.odysseus.staxon.json.JsonXMLOutputFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.module.json.transformers.AbstractToFromXmlTransformer;
import org.mule.runtime.module.json.transformers.TransformerInputs;
import org.w3c.dom.Document;

public class XmlToJson
extends AbstractToFromXmlTransformer {
    public XmlToJson() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.fromType(Reader.class));
        this.registerSourceType(DataType.fromType(URL.class));
        this.registerSourceType(DataType.fromType(File.class));
        this.registerSourceType(DataType.fromType(Document.class));
        this.setReturnDataType(DataType.JSON_STRING);
    }

    protected Object doTransform(Object src, Charset enc) throws TransformerException {
        XMLInputFactory inputFactory = XMLSecureFactories.createDefault().getXMLInputFactory();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        TransformerInputs inputs = null;
        try {
            Source source;
            if (src instanceof Document) {
                Document doc = (Document)src;
                String location = doc.getDocumentURI();
                if (location == null) {
                    location = "(Document)";
                }
                source = new DOMSource(doc, location);
            } else {
                inputs = new TransformerInputs((Transformer)this, src);
                source = inputs.getInputStream() != null ? new StAXSource(inputFactory.createXMLStreamReader(inputs.getInputStream(), enc == null ? StandardCharsets.UTF_8.name() : enc.name())) : new StAXSource(inputFactory.createXMLStreamReader(inputs.getReader()));
            }
            JsonXMLOutputFactory outputFactory = new JsonXMLOutputFactory();
            outputFactory.setProperty("JsonXMLOutputFactory.autoArray", true);
            outputFactory.setProperty("JsonXMLOutputFactory.prettyPrint", true);
            String string = this.convert(source, (XMLOutputFactory)outputFactory);
            return string;
        }
        catch (Exception ex) {
            throw new TransformerException((Transformer)this, (Throwable)ex);
        }
        finally {
            if (inputs != null) {
                IOUtils.closeQuietly((InputStream)inputs.getInputStream());
                IOUtils.closeQuietly((Reader)inputs.getReader());
            }
        }
    }
}

