/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.transformers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.ClassUtils;

public class TransformerInputs {
    private static final String PREFERRED_TRANSFORMATION_FACTORY_CLASS_NAME = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static final String PREFERRED_SCHEMA_FACTORY_CLASS_NAME = "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory";
    private InputStream is;
    private Reader reader;

    TransformerInputs(Transformer xform, Object src) throws TransformerException {
        try {
            if (src instanceof InputStream) {
                this.is = (InputStream)src;
            } else if (src instanceof File) {
                this.is = new FileInputStream((File)src);
            } else if (src instanceof URL) {
                this.is = ((URL)src).openStream();
            } else if (src instanceof byte[]) {
                this.is = new ByteArrayInputStream((byte[])src);
            } else if (src instanceof Reader) {
                this.reader = (Reader)src;
            } else if (src instanceof String) {
                this.reader = new StringReader((String)src);
            }
            if (this.is != null || this.reader != null) {
                return;
            }
        }
        catch (IOException ex) {
            throw new TransformerException(xform, (Throwable)ex);
        }
        throw new TransformerException(CoreMessages.transformFailed((String)src.getClass().getName(), (String)"xml"));
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public Reader getReader() {
        return this.reader;
    }

    public static TransformerFactory createTransformerFactory() {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = (TransformerFactory)ClassUtils.getClass((String)PREFERRED_TRANSFORMATION_FACTORY_CLASS_NAME).newInstance();
        }
        catch (Exception ex) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static SchemaFactory createSchemaFactory(String schemaLanguage) {
        SchemaFactory schemaFactory;
        try {
            schemaFactory = (SchemaFactory)ClassUtils.instanciateClass((String)PREFERRED_SCHEMA_FACTORY_CLASS_NAME, (Object[])new Object[0]);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        }
        System.out.println(schemaFactory.getClass());
        return schemaFactory;
    }

    public static String getPreferredTransactionFactoryClassname() {
        return PREFERRED_TRANSFORMATION_FACTORY_CLASS_NAME;
    }
}

