/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.transformers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.module.json.filters.IsJsonFilter;
import org.mule.runtime.module.json.transformers.AbstractJsonTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectToJson
extends AbstractJsonTransformer {
    protected final transient Logger logger = LoggerFactory.getLogger(ObjectToJson.class);
    private Map<Class<?>, Class<?>> serializationMixins = new HashMap();
    protected Class<?> sourceClass;
    private boolean handleException = false;
    private IsJsonFilter isJsonFilter = new IsJsonFilter();

    public ObjectToJson() {
        this.setReturnDataType(DataType.JSON_STRING);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getSourceClass() != null) {
            this.sourceTypes.clear();
            this.registerSourceType(DataType.fromType(this.getSourceClass()));
        }
        for (Map.Entry<Class<?>, Class<?>> entry : this.getMixins().entrySet()) {
            this.getMapper().getSerializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Class<?>> entry : this.serializationMixins.entrySet()) {
            this.getMapper().getSerializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
    }

    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        Object src = event.getMessage().getPayload().getValue();
        if (src instanceof String && this.isJsonFilter.accept(src)) {
            return src;
        }
        if (event.getError().isPresent() && this.isHandleException()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found exception with null payload");
            }
            src = this.getException(((Error)event.getError().get()).getCause());
        }
        StringWriter writer = new StringWriter();
        try {
            this.getMapper().writeValue((Writer)writer, src);
        }
        catch (IOException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        if (byte[].class.equals((Object)this.getReturnDataType().getType())) {
            return writer.toString().getBytes(outputEncoding);
        }
        return writer.toString();
    }

    private Exception getException(Throwable t) {
        Exception returnValue = null;
        ArrayList<Throwable> causeStack = new ArrayList<Throwable>();
        for (Throwable tempCause = t; tempCause != null; tempCause = tempCause.getCause()) {
            causeStack.add(tempCause);
        }
        for (int i = causeStack.size() - 1; i >= 0; --i) {
            Throwable tempCause = (Throwable)causeStack.get(i);
            if (i == causeStack.size()) {
                returnValue = new Exception(tempCause.getMessage());
                returnValue.setStackTrace(tempCause.getStackTrace());
                continue;
            }
            returnValue = new Exception(tempCause.getMessage(), returnValue);
            returnValue.setStackTrace(tempCause.getStackTrace());
        }
        return returnValue;
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public Map<Class<?>, Class<?>> getSerializationMixins() {
        return this.serializationMixins;
    }

    public void setSerializationMixins(Map<Class<?>, Class<?>> serializationMixins) {
        this.serializationMixins = serializationMixins;
    }
}

