/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.transformers;

import de.odysseus.staxon.json.JsonXMLInputFactory;
import de.odysseus.staxon.json.JsonXMLOutputFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.json.transformers.TransformerInputs;
import org.mule.runtime.module.xml.transformer.XsltTransformer;

public class JsonXsltTransformer
extends XsltTransformer {
    public JsonXsltTransformer() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.fromType(Reader.class));
        this.registerSourceType(DataType.fromType(URL.class));
        this.registerSourceType(DataType.fromType(File.class));
        this.setReturnDataType(DataType.XML_STRING);
        this.setXslTransformerFactory(TransformerInputs.getPreferredTransactionFactoryClassname());
    }

    public Object transformMessage(Event event, Charset enc) throws TransformerException {
        JsonXMLInputFactory inputFactory = new JsonXMLInputFactory();
        inputFactory.setProperty("JsonXMLInputFactory.multiplePI", false);
        TransformerInputs inputs = new TransformerInputs((Transformer)this, event.getMessage().getPayload().getValue());
        try {
            StAXSource source = inputs.getInputStream() != null ? new StAXSource(inputFactory.createXMLStreamReader(inputs.getInputStream(), enc == null ? StandardCharsets.UTF_8.name() : enc.name())) : new StAXSource(inputFactory.createXMLStreamReader(inputs.getReader()));
            JsonXMLOutputFactory outputFactory = new JsonXMLOutputFactory();
            outputFactory.setProperty("JsonXMLOutputFactory.autoArray", true);
            outputFactory.setProperty("JsonXMLOutputFactory.prettyPrint", true);
            StringWriter writer = new StringWriter();
            XMLStreamWriter output = outputFactory.createXMLStreamWriter(writer);
            StAXResult result = new StAXResult(output);
            this.doTransform(event, enc, source, result);
            String string = writer.toString();
            return string;
        }
        catch (Exception ex) {
            throw new TransformerException((Transformer)this, (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputs.getInputStream());
            IOUtils.closeQuietly((Reader)inputs.getReader());
        }
    }
}

