/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.transformers;

import de.odysseus.staxon.json.JsonXMLInputFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.stax.StAXSource;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.json.transformers.AbstractToFromXmlTransformer;
import org.mule.runtime.module.json.transformers.TransformerInputs;

public class JsonToXml
extends AbstractToFromXmlTransformer {
    public JsonToXml() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.fromType(Reader.class));
        this.registerSourceType(DataType.fromType(URL.class));
        this.registerSourceType(DataType.fromType(File.class));
        this.setReturnDataType(DataType.XML_STRING);
    }

    protected Object doTransform(Object src, Charset enc) throws TransformerException {
        JsonXMLInputFactory inputFactory = new JsonXMLInputFactory();
        inputFactory.setProperty("JsonXMLInputFactory.multiplePI", false);
        TransformerInputs inputs = new TransformerInputs((Transformer)this, src);
        try {
            StAXSource source = inputs.getInputStream() != null ? new StAXSource(inputFactory.createXMLStreamReader(inputs.getInputStream(), enc == null ? StandardCharsets.UTF_8.name() : enc.name())) : new StAXSource(inputFactory.createXMLStreamReader(inputs.getReader()));
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            String string = this.convert(source, outputFactory);
            return string;
        }
        catch (Exception ex) {
            throw new TransformerException((Transformer)this, (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputs.getInputStream());
            IOUtils.closeQuietly((Reader)inputs.getReader());
        }
    }
}

