/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.transformers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.json.JsonData;
import org.mule.runtime.module.json.transformers.AbstractJsonTransformer;

public class JsonToObject
extends AbstractJsonTransformer {
    private static final DataType JSON_TYPE = DataType.builder().type(JsonData.class).mediaType(MediaType.APPLICATION_JSON).build();
    private Map<Class<?>, Class<?>> deserializationMixins = new HashMap();

    public JsonToObject() {
        this.registerSourceType(DataType.fromType(Reader.class));
        this.registerSourceType(DataType.fromType(URL.class));
        this.registerSourceType(DataType.fromType(File.class));
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.setReturnDataType(JSON_TYPE);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        for (Map.Entry<Class<?>, Class<?>> entry : this.getMixins().entrySet()) {
            this.getMapper().getDeserializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Class<?>> entry : this.deserializationMixins.entrySet()) {
            this.getMapper().getDeserializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
    }

    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        JsonData jsonData;
        Object src = event.getMessage().getPayload().getValue();
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            Object returnValue;
            if (src instanceof InputStream) {
                is = (InputStream)src;
            } else if (src instanceof File) {
                is = new FileInputStream((File)src);
            } else if (src instanceof URL) {
                is = ((URL)src).openStream();
            } else if (src instanceof byte[]) {
                is = new ByteArrayInputStream((byte[])src);
            }
            if (src instanceof Reader) {
                returnValue = JSON_TYPE.isCompatibleWith(this.getReturnDataType()) ? new JsonData((Reader)src) : this.getMapper().readValue((Reader)src, this.getReturnDataType().getType());
            } else if (src instanceof String) {
                returnValue = JSON_TYPE.isCompatibleWith(this.getReturnDataType()) ? new JsonData((String)src) : this.getMapper().readValue((String)src, this.getReturnDataType().getType());
            } else {
                reader = new InputStreamReader(is, outputEncoding);
                returnValue = JSON_TYPE.isCompatibleWith(this.getReturnDataType()) ? new JsonData(reader) : this.getMapper().readValue((Reader)reader, this.getReturnDataType().getType());
            }
            jsonData = returnValue;
        }
        catch (Exception e) {
            try {
                throw new TransformerException(CoreMessages.transformFailed((String)"json", (String)this.getReturnDataType().getType().getName()), (Transformer)this, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)is);
        return jsonData;
    }

    public Map<Class<?>, Class<?>> getDeserializationMixins() {
        return this.deserializationMixins;
    }

    public void setDeserializationMixins(Map<Class<?>, Class<?>> deserializationMixins) {
        this.deserializationMixins = deserializationMixins;
    }
}

