/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.filters;

import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsJsonFilter
implements Filter,
MuleContextAware {
    protected final transient Logger logger = LoggerFactory.getLogger(IsJsonFilter.class);
    private boolean validateParsing = false;
    private MuleContext muleContext;

    public boolean accept(InternalMessage obj, Event.Builder builder) {
        if (MediaType.APPLICATION_JSON.matches(obj.getPayload().getDataType().getMediaType())) {
            return true;
        }
        try {
            return this.accept(this.muleContext.getTransformationService().transform(obj, DataType.STRING).getPayload().getValue());
        }
        catch (Exception e) {
            this.logger.warn("Failed to read object payload as string for isJsonFilter", (Throwable)e);
            return false;
        }
    }

    public boolean accept(Object obj) {
        try {
            if (obj instanceof byte[]) {
                obj = new String((byte[])obj);
            }
            if (obj instanceof String) {
                if (!this.mayBeJSON((String)obj)) {
                    return false;
                }
                if (this.isValidateParsing()) {
                    new ObjectMapper().readTree((String)obj);
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.logger.error("Filter result = false (message is not valid JSON): " + e.getMessage());
            return false;
        }
    }

    public boolean isValidateParsing() {
        return this.validateParsing;
    }

    public void setValidateParsing(boolean validateParsing) {
        this.validateParsing = validateParsing;
    }

    protected boolean mayBeJSON(String string) {
        return string != null && ("null".equals(string) || string.startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}"));
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

